@extends('layouts.admin')

@section('title', 'Edit Lamaran Pekerjaan')

@section('content')
<div class="mb-6">
    <div class="flex items-center">
        <a href="{{ route('admin.job-applications.index') }}" 
           class="text-gray-500 hover:text-gray-700 transition duration-150 ease-in-out mr-4">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Edit Lamaran Pekerjaan</h1>
            <p class="mt-1 text-sm text-gray-600">Edit data lamaran dari {{ $jobApplication->name }}</p>
        </div>
    </div>
</div>

<form action="{{ route('admin.job-applications.update', $jobApplication) }}" method="POST" enctype="multipart/form-data" class="space-y-6">
    @csrf
    @method('PUT')
    
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Applicant Information -->
            <div class="bg-white shadow-sm border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Pelamar</h3>
                
                <div class="space-y-4">
                    <!-- Name -->
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                            Nama Lengkap <span class="text-red-500">*</span>
                        </label>
                        <input type="text" 
                               name="name" 
                               id="name" 
                               value="{{ old('name', $jobApplication->name) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('name') border-red-500 @enderror"
                               placeholder="Masukkan nama lengkap pelamar">
                        @error('name')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Email -->
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                            Email <span class="text-red-500">*</span>
                        </label>
                        <input type="email" 
                               name="email" 
                               id="email" 
                               value="{{ old('email', $jobApplication->email) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('email') border-red-500 @enderror"
                               placeholder="contoh@email.com">
                        @error('email')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Phone -->
                    <div>
                        <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">
                            Nomor Telepon <span class="text-red-500">*</span>
                        </label>
                        <input type="text" 
                               name="phone" 
                               id="phone" 
                               value="{{ old('phone', $jobApplication->phone) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('phone') border-red-500 @enderror"
                               placeholder="08xxxxxxxxxx">
                        @error('phone')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Portfolio URL -->
                    <div>
                        <label for="portfolio_url" class="block text-sm font-medium text-gray-700 mb-2">
                            URL Portfolio
                        </label>
                        <input type="url" 
                               name="portfolio_url" 
                               id="portfolio_url" 
                               value="{{ old('portfolio_url', $jobApplication->portfolio_url) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('portfolio_url') border-red-500 @enderror"
                               placeholder="https://portfolio.contoh.com">
                        @error('portfolio_url')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Cover Letter -->
                    <div>
                        <label for="cover_letter" class="block text-sm font-medium text-gray-700 mb-2">
                            Cover Letter <span class="text-red-500">*</span>
                        </label>
                        <textarea name="cover_letter" 
                                  id="cover_letter" 
                                  rows="6" 
                                  class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('cover_letter') border-red-500 @enderror"
                                  placeholder="Tulis cover letter atau motivasi melamar">{{ old('cover_letter', $jobApplication->cover_letter) }}</textarea>
                        @error('cover_letter')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Current Resume Info & New Upload -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">
                            Resume/CV
                        </label>
                        
                        @if($jobApplication->resume_path)
                            <div class="mb-3 p-3 bg-gray-50 border border-gray-200 rounded-lg">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center">
                                        <i class="fas fa-file-pdf text-red-500 mr-2"></i>
                                        <span class="text-sm text-gray-700">Resume saat ini</span>
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        <a href="{{ Storage::url($jobApplication->resume_path) }}" 
                                           target="_blank"
                                           class="text-blue-600 hover:text-blue-700 text-sm">
                                            <i class="fas fa-download mr-1"></i>
                                            Download
                                        </a>
                                        <label class="flex items-center">
                                            <input type="checkbox" name="remove_resume" value="1" class="mr-1">
                                            <span class="text-red-600 text-sm">Hapus</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        @endif
                        
                        <input type="file" 
                               name="resume" 
                               id="resume" 
                               accept=".pdf,.doc,.docx"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('resume') border-red-500 @enderror">
                        <p class="mt-1 text-xs text-gray-500">
                            {{ $jobApplication->resume_path ? 'Upload file baru untuk mengganti resume yang ada' : 'Format yang diterima: PDF, DOC, DOCX. Maksimal 5MB' }}
                        </p>
                        @error('resume')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Admin Notes -->
            <div class="bg-white shadow-sm border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Catatan Admin</h3>
                
                <div>
                    <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">
                        Catatan Internal
                    </label>
                    <textarea name="notes" 
                              id="notes" 
                              rows="4" 
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('notes') border-red-500 @enderror"
                              placeholder="Catatan internal untuk tim HR">{{ old('notes', $jobApplication->notes) }}</textarea>
                    @error('notes')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Publication Settings -->
            <div class="bg-white shadow-sm border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Pengaturan Lamaran</h3>
                
                <div class="space-y-4">
                    <!-- Job Position -->
                    <div>
                        <label for="job_listing_id" class="block text-sm font-medium text-gray-700 mb-2">
                            Posisi Pekerjaan <span class="text-red-500">*</span>
                        </label>
                        <select name="job_listing_id" 
                                id="job_listing_id" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('job_listing_id') border-red-500 @enderror">
                            <option value="">Pilih posisi pekerjaan</option>
                            @foreach($jobListings as $job)
                                <option value="{{ $job->id }}" {{ old('job_listing_id', $jobApplication->job_listing_id) == $job->id ? 'selected' : '' }}>
                                    {{ $job->title }} - {{ $job->department }}
                                </option>
                            @endforeach
                        </select>
                        @error('job_listing_id')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Status -->
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700 mb-2">
                            Status Lamaran <span class="text-red-500">*</span>
                        </label>
                        <select name="status" 
                                id="status" 
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('status') border-red-500 @enderror">
                            <option value="pending" {{ old('status', $jobApplication->status) == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="reviewed" {{ old('status', $jobApplication->status) == 'reviewed' ? 'selected' : '' }}>Reviewed</option>
                            <option value="interview" {{ old('status', $jobApplication->status) == 'interview' ? 'selected' : '' }}>Interview</option>
                            <option value="accepted" {{ old('status', $jobApplication->status) == 'accepted' ? 'selected' : '' }}>Accepted</option>
                            <option value="rejected" {{ old('status', $jobApplication->status) == 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </select>
                        @error('status')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Application Info -->
            <div class="bg-white shadow-sm border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Lamaran</h3>
                
                <div class="space-y-3 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-500">Tanggal Apply:</span>
                        <span class="text-gray-900">{{ $jobApplication->created_at->format('d M Y') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Terakhir Update:</span>
                        <span class="text-gray-900">{{ $jobApplication->updated_at->format('d M Y H:i') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">ID Lamaran:</span>
                        <span class="text-gray-900">#{{ $jobApplication->id }}</span>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-white shadow-sm border border-gray-200 rounded-lg p-6">
                <div class="flex flex-col space-y-3">
                    <button type="submit" 
                            class="w-full inline-flex justify-center items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-medium text-sm text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                        <i class="fas fa-save mr-2"></i>
                        Update Lamaran
                    </button>
                    <a href="{{ route('admin.job-applications.show', $jobApplication) }}" 
                       class="w-full inline-flex justify-center items-center px-4 py-2 bg-green-600 border border-transparent rounded-md font-medium text-sm text-white hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition duration-150 ease-in-out">
                        <i class="fas fa-eye mr-2"></i>
                        Lihat Detail
                    </a>
                    <a href="{{ route('admin.job-applications.index') }}" 
                       class="w-full inline-flex justify-center items-center px-4 py-2 bg-gray-300 border border-transparent rounded-md font-medium text-sm text-gray-700 hover:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 transition duration-150 ease-in-out">
                        <i class="fas fa-times mr-2"></i>
                        Batal
                    </a>
                </div>
            </div>
        </div>
    </div>
</form>

@push('scripts')
<script>
// File upload preview
document.getElementById('resume').addEventListener('change', function() {
    const file = this.files[0];
    if (file) {
        console.log('File selected:', file.name);
    }
});

// Prevent accidental removal
document.querySelector('input[name="remove_resume"]').addEventListener('change', function() {
    if (this.checked) {
        if (!confirm('Apakah Anda yakin ingin menghapus resume yang ada?')) {
            this.checked = false;
        }
    }
});
</script>
@endpush

@endsection
