@extends('layouts.admin')

@section('title', 'Detail Kategori Produk')

@section('content')
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <a href="{{ route('admin.product-categories.index') }}" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-arrow-left text-xl"></i>
                </a>
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">{{ $productCategory->name }}</h1>
                    <p class="mt-1 text-sm text-gray-600">Detail kategori produk</p>
                </div>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('admin.product-categories.edit', $productCategory) }}" 
                   class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-lg font-medium text-sm text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                    <i class="fas fa-edit mr-2"></i>
                    Edit Kategori
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Category Information -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Info -->
            <div class="bg-white shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Informasi Kategori</h3>
                </div>
                <div class="px-6 py-6">
                    <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Nama Kategori</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $productCategory->name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Slug</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono bg-gray-100 px-2 py-1 rounded">{{ $productCategory->slug }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd class="mt-1">
                                @if($productCategory->is_active)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        <i class="fas fa-check mr-1"></i>
                                        Aktif
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                        <i class="fas fa-times mr-1"></i>
                                        Nonaktif
                                    </span>
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Urutan Tampil</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $productCategory->sort_order }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Jumlah Produk</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $productCategory->products->count() }} produk</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Dibuat</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $productCategory->created_at->format('d M Y H:i') }}</dd>
                        </div>
                    </dl>

                    @if($productCategory->description)
                        <div class="mt-6">
                            <dt class="text-sm font-medium text-gray-500">Deskripsi</dt>
                            <dd class="mt-2 text-sm text-gray-900">{{ $productCategory->description }}</dd>
                        </div>
                    @endif
                </div>
            </div>

            <!-- SEO Information -->
            @if($productCategory->meta_title || $productCategory->meta_description)
                <div class="bg-white shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Informasi SEO</h3>
                    </div>
                    <div class="px-6 py-6">
                        <dl class="space-y-4">
                            @if($productCategory->meta_title)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Meta Title</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $productCategory->meta_title }}</dd>
                                </div>
                            @endif
                            @if($productCategory->meta_description)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Meta Description</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $productCategory->meta_description }}</dd>
                                </div>
                            @endif
                        </dl>
                    </div>
                </div>
            @endif

            <!-- Recent Products -->
            @if($productCategory->products->count() > 0)
                <div class="bg-white shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <div class="flex items-center justify-between">
                            <h3 class="text-lg leading-6 font-medium text-gray-900">Produk Terbaru</h3>
                            <a href="{{ route('admin.products.index', ['category_id' => $productCategory->id]) }}" class="text-sm text-blue-600 hover:text-blue-500">
                                Lihat Semua
                            </a>
                        </div>
                    </div>
                    <div class="px-6 py-6">
                        <div class="space-y-4">
                            @foreach($productCategory->products->take(5) as $product)
                                <div class="flex items-center space-x-4">
                                    @if($product->featured_image)
                                        <img class="h-12 w-12 rounded-lg object-cover" src="{{ $product->featured_image_url }}" alt="{{ $product->name }}">
                                    @else
                                        <div class="h-12 w-12 bg-gray-200 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-shopping-cart text-gray-500"></i>
                                        </div>
                                    @endif
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-medium text-gray-900 truncate">{{ $product->name }}</p>
                                        <p class="text-sm text-gray-500">{{ $product->formatted_final_price }}</p>
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        @if($product->is_active)
                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800">
                                                Aktif
                                            </span>
                                        @else
                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800">
                                                Nonaktif
                                            </span>
                                        @endif
                                        <a href="{{ route('admin.products.show', $product) }}" class="text-blue-600 hover:text-blue-500">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Category Image -->
            @if($productCategory->image)
                <div class="bg-white shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Gambar Kategori</h3>
                    </div>
                    <div class="px-6 py-6">
                        <img class="w-full h-48 object-cover rounded-lg" src="{{ $productCategory->image_url }}" alt="{{ $productCategory->name }}">
                    </div>
                </div>
            @endif

            <!-- Quick Stats -->
            <div class="bg-white shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Statistik</h3>
                </div>
                <div class="px-6 py-6">
                    <dl class="space-y-4">
                        <div class="flex items-center justify-between">
                            <dt class="text-sm font-medium text-gray-500">Total Produk</dt>
                            <dd class="text-sm font-medium text-gray-900">{{ $productCategory->products->count() }}</dd>
                        </div>
                        <div class="flex items-center justify-between">
                            <dt class="text-sm font-medium text-gray-500">Produk Aktif</dt>
                            <dd class="text-sm font-medium text-gray-900">{{ $productCategory->products->where('is_active', true)->count() }}</dd>
                        </div>
                        <div class="flex items-center justify-between">
                            <dt class="text-sm font-medium text-gray-500">Produk Unggulan</dt>
                            <dd class="text-sm font-medium text-gray-900">{{ $productCategory->products->where('is_featured', true)->count() }}</dd>
                        </div>
                        <div class="flex items-center justify-between">
                            <dt class="text-sm font-medium text-gray-500">Stok Habis</dt>
                            <dd class="text-sm font-medium text-gray-900">{{ $productCategory->products->where('stock', 0)->count() }}</dd>
                        </div>
                    </dl>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Aksi Cepat</h3>
                </div>
                <div class="px-6 py-6 space-y-3">
                    <a href="{{ route('admin.products.create', ['category_id' => $productCategory->id]) }}" 
                       class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                        <i class="fas fa-plus mr-2"></i>
                        Tambah Produk
                    </a>
                    <a href="{{ route('admin.products.index', ['category_id' => $productCategory->id]) }}" 
                       class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        <i class="fas fa-list mr-2"></i>
                        Lihat Semua Produk
                    </a>
                    <a href="{{ route('products.category', $productCategory->slug) }}" 
                       target="_blank"
                       class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        <i class="fas fa-external-link-alt mr-2"></i>
                        Lihat di Website
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection
