@extends('layouts.admin')

@section('title', 'Detail Produk')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">{{ $product->name }}</h1>
                <p class="mt-1 text-sm text-gray-600">Detail informasi produk</p>
            </div>
            <div class="mt-4 sm:mt-0 flex space-x-3">
                <a href="{{ route('admin.products.index') }}" 
                   class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Kembali
                </a>
                <a href="{{ route('admin.products.edit', $product) }}" 
                   class="inline-flex items-center px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-yellow-600 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 transition duration-150 ease-in-out">
                    <i class="fas fa-edit mr-2"></i>
                    Edit
                </a>
                <a href="{{ route('products.show', $product->slug) }}" target="_blank"
                   class="inline-flex items-center px-4 py-2 border border-transparent rounded-lg text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                    <i class="fas fa-external-link-alt mr-2"></i>
                    Lihat Frontend
                </a>
            </div>
        </div>
    </div>

    <!-- Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Left Column - Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Information -->
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Informasi Dasar</h3>
                </div>
                <div class="px-6 py-4">
                    <dl class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Nama Produk</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $product->name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Slug</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono bg-gray-100 px-2 py-1 rounded">{{ $product->slug }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Kategori</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    {{ $product->category->name }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Brand</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $product->brand ?: '-' }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">SKU</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $product->sku }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd class="mt-1 flex space-x-2">
                                @if($product->is_active)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        Aktif
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                        Tidak Aktif
                                    </span>
                                @endif
                                
                                @if($product->is_featured)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                        Unggulan
                                    </span>
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Dibuat</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $product->created_at->format('d M Y H:i') }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Diperbarui</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $product->updated_at->format('d M Y H:i') }}</dd>
                        </div>
                    </dl>
                </div>
            </div>

            <!-- Description -->
            @if($product->short_description || $product->description)
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Deskripsi</h3>
                </div>
                <div class="px-6 py-4">
                    @if($product->short_description)
                    <div class="mb-4">
                        <h4 class="text-sm font-medium text-gray-500 mb-2">Deskripsi Singkat:</h4>
                        <p class="text-sm text-gray-900">{{ $product->short_description }}</p>
                    </div>
                    @endif

                    @if($product->description)
                    <div>
                        <h4 class="text-sm font-medium text-gray-500 mb-2">Deskripsi Lengkap:</h4>
                        <div class="prose prose-sm max-w-none">
                            <div class="bg-gray-50 p-4 rounded-lg max-h-64 overflow-y-auto">
                                {!! nl2br(e($product->description)) !!}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            @endif

            <!-- Specifications -->
            @if($product->specifications)
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Spesifikasi</h3>
                </div>
                <div class="px-6 py-4">
                    <dl class="grid grid-cols-1 gap-3">
                        @foreach($product->specifications as $spec)
                        <div class="flex justify-between py-2 border-b border-gray-100 last:border-b-0">
                            <dt class="text-sm font-medium text-gray-500">{{ $spec['key'] ?? 'N/A' }}</dt>
                            <dd class="text-sm text-gray-900">{{ $spec['value'] ?? 'N/A' }}</dd>
                        </div>
                        @endforeach
                    </dl>
                </div>
            </div>
            @endif

            <!-- Marketplace Links -->
            @if($product->marketplace_links)
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Link Marketplace</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                        @if($product->shopee_url)
                        <a href="{{ $product->shopee_url }}" target="_blank" 
                           class="flex items-center justify-center px-4 py-2 bg-orange-500 text-white rounded-lg hover:bg-orange-600 transition duration-150 ease-in-out">
                            <i class="fab fa-shopify mr-2"></i>
                            Beli di Shopee
                        </a>
                        @endif

                        @if($product->tokopedia_url)
                        <a href="{{ $product->tokopedia_url }}" target="_blank" 
                           class="flex items-center justify-center px-4 py-2 bg-green-500 text-white rounded-lg hover:bg-green-600 transition duration-150 ease-in-out">
                            <i class="fas fa-shopping-cart mr-2"></i>
                            Beli di Tokopedia
                        </a>
                        @endif

                        @if($product->bukalapak_url)
                        <a href="{{ $product->bukalapak_url }}" target="_blank" 
                           class="flex items-center justify-center px-4 py-2 bg-pink-500 text-white rounded-lg hover:bg-pink-600 transition duration-150 ease-in-out">
                            <i class="fas fa-shopping-bag mr-2"></i>
                            Beli di Bukalapak
                        </a>
                        @endif

                        @if($product->lazada_url)
                        <a href="{{ $product->lazada_url }}" target="_blank" 
                           class="flex items-center justify-center px-4 py-2 bg-blue-800 text-white rounded-lg hover:bg-blue-900 transition duration-150 ease-in-out">
                            <i class="fas fa-store mr-2"></i>
                            Beli di Lazada
                        </a>
                        @endif

                        @if($product->blibli_url)
                        <a href="{{ $product->blibli_url }}" target="_blank" 
                           class="flex items-center justify-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition duration-150 ease-in-out">
                            <i class="fas fa-store mr-2"></i>
                            Beli di Blibli
                        </a>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            <!-- SEO Information -->
            @if($product->meta_title || $product->meta_description)
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Informasi SEO</h3>
                </div>
                <div class="px-6 py-4">
                    @if($product->meta_title)
                    <div class="mb-4">
                        <h4 class="text-sm font-medium text-gray-500 mb-2">Meta Title:</h4>
                        <p class="text-sm text-gray-900">{{ $product->meta_title }}</p>
                    </div>
                    @endif

                    @if($product->meta_description)
                    <div>
                        <h4 class="text-sm font-medium text-gray-500 mb-2">Meta Description:</h4>
                        <p class="text-sm text-gray-900">{{ $product->meta_description }}</p>
                    </div>
                    @endif
                </div>
            </div>
            @endif
        </div>

        <!-- Right Column - Sidebar -->
        <div class="space-y-6">
            <!-- Pricing & Inventory -->
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Harga & Stok</h3>
                </div>
                <div class="px-6 py-4">
                    <dl class="space-y-4">
                        <div class="flex justify-between">
                            <dt class="text-sm font-medium text-gray-500">Harga Normal</dt>
                            <dd class="text-lg font-semibold text-green-600">
                                {{ $product->formatted_price }}
                            </dd>
                        </div>
                        @if($product->discount_price)
                        <div class="flex justify-between">
                            <dt class="text-sm font-medium text-gray-500">Harga Final</dt>
                            <dd class="text-lg font-semibold text-red-600">
                                {{ $product->formatted_final_price }}
                            </dd>
                        </div>
                        <div class="flex justify-between">
                            <dt class="text-sm font-medium text-gray-500">Diskon</dt>
                            <dd>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                    {{ number_format($product->discount_percentage, 1) }}%
                                </span>
                            </dd>
                        </div>
                        @endif
                        <div class="flex justify-between">
                            <dt class="text-sm font-medium text-gray-500">Stok</dt>
                            <dd>
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $product->stock > 0 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $product->stock }}
                                </span>
                            </dd>
                        </div>
                        <div class="flex justify-between">
                            <dt class="text-sm font-medium text-gray-500">Status Stok</dt>
                            <dd class="text-sm text-gray-900">{{ $product->stock_status }}</dd>
                        </div>
                        <div class="flex justify-between">
                            <dt class="text-sm font-medium text-gray-500">Views</dt>
                            <dd class="text-sm text-gray-900">{{ number_format($product->views) }}</dd>
                        </div>
                        <div class="flex justify-between">
                            <dt class="text-sm font-medium text-gray-500">Terjual</dt>
                            <dd class="text-sm text-gray-900">{{ number_format($product->sales_count) }}</dd>
                        </div>
                    </dl>
                </div>
            </div>

            <!-- Featured Image -->
            @if($product->featured_image)
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Gambar Utama</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="text-center">
                        <img src="{{ $product->featured_image_url }}" 
                             class="w-full h-64 object-cover rounded-lg" 
                             alt="{{ $product->name }}">
                    </div>
                </div>
            </div>
            @endif

            <!-- Gallery -->
            @if($product->gallery && count($product->gallery) > 0)
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Galeri ({{ count($product->gallery) }})</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="grid grid-cols-2 gap-4">
                        @foreach($product->gallery_urls as $image)
                        <div>
                            <a href="{{ $image }}" target="_blank">
                                <img src="{{ $image }}" 
                                     class="w-full h-24 object-cover rounded-lg hover:opacity-75 transition duration-150 ease-in-out" 
                                     alt="{{ $product->name }}">
                            </a>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif

            <!-- Actions -->
            <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Aksi</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="space-y-3">
                        <a href="{{ route('admin.products.edit', $product) }}" 
                           class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-yellow-600 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 transition duration-150 ease-in-out">
                            <i class="fas fa-edit mr-2"></i>
                            Edit Produk
                        </a>
                        
                        <a href="{{ route('products.show', $product->slug) }}" target="_blank" 
                           class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                            <i class="fas fa-external-link-alt mr-2"></i>
                            Lihat di Frontend
                        </a>

                        @if($product->is_active)
                            <form action="{{ route('admin.products.update', $product) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="is_active" value="0">
                                <button type="submit" 
                                        class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-gray-600 hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 transition duration-150 ease-in-out" 
                                        onclick="return confirm('Nonaktifkan produk ini?')">
                                    <i class="fas fa-eye-slash mr-2"></i>
                                    Nonaktifkan
                                </button>
                            </form>
                        @else
                            <form action="{{ route('admin.products.update', $product) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="is_active" value="1">
                                <button type="submit" 
                                        class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition duration-150 ease-in-out">
                                    <i class="fas fa-eye mr-2"></i>
                                    Aktifkan
                                </button>
                            </form>
                        @endif

                        <form action="{{ route('admin.products.destroy', $product) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" 
                                    class="w-full inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 transition duration-150 ease-in-out" 
                                    onclick="return confirm('Hapus produk ini? Aksi ini tidak dapat dibatalkan!')">
                                <i class="fas fa-trash mr-2"></i>
                                Hapus Produk
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
