<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\AboutController;
use App\Http\Controllers\Frontend\ServiceController;
use App\Http\Controllers\Frontend\ProjectController;
use App\Http\Controllers\Frontend\ArticleController;
use App\Http\Controllers\Frontend\CareerController;
use App\Http\Controllers\Frontend\ContactController;
use App\Http\Controllers\Frontend\ProductController;

// Frontend Routes
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/tentang-kami', [AboutController::class, 'index'])->name('about');
Route::get('/tim/{id}', [AboutController::class, 'teamDetail'])->name('team.detail');

// Services
Route::get('/layanan', [ServiceController::class, 'index'])->name('services.index');
Route::get('/layanan/{slug}', [ServiceController::class, 'show'])->name('services.show');

// Products
Route::get('/produk', [ProductController::class, 'index'])->name('products.index');
Route::get('/produk/kategori/{slug}', [ProductController::class, 'category'])->name('products.category');
Route::get('/produk/cari', [ProductController::class, 'search'])->name('products.search');
Route::get('/produk/{slug}', [ProductController::class, 'show'])->name('products.show');

// Projects/Portfolio
Route::get('/portofolio', [ProjectController::class, 'index'])->name('projects.index');
Route::get('/portofolio/{slug}', [ProjectController::class, 'show'])->name('projects.show');

// Articles
Route::get('/artikel', [ArticleController::class, 'index'])->name('articles.index');
Route::get('/artikel/{slug}', [ArticleController::class, 'show'])->name('articles.show');

// Careers
Route::get('/karier', [CareerController::class, 'index'])->name('careers.index');
Route::get('/karier/{slug}', [CareerController::class, 'show'])->name('careers.show');
Route::get('/karier/{slug}/apply', [CareerController::class, 'showApplyForm'])->name('careers.apply');
Route::post('/karier/{slug}/apply', [CareerController::class, 'apply'])->name('careers.apply.store');

// Contact
Route::get('/kontak', [ContactController::class, 'index'])->name('contact');
Route::post('/kontak', [ContactController::class, 'store'])->name('contact.store');

// Admin Authentication Routes (Public)
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/login', [App\Http\Controllers\Admin\AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [App\Http\Controllers\Admin\AuthController::class, 'login']);
    Route::post('/logout', [App\Http\Controllers\Admin\AuthController::class, 'logout'])->name('logout');
});

// Admin Routes (Protected with auth middleware)
Route::prefix('admin')->name('admin.')->middleware('admin.auth')->group(function () {
    Route::get('/dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    
    // Settings
    Route::resource('settings', App\Http\Controllers\Admin\SettingController::class);
    
    // Page SEO Management
    Route::resource('page-seo', App\Http\Controllers\Admin\PageSeoController::class);
    
    // Page Hero Management
    Route::resource('page-hero', App\Http\Controllers\Admin\PageHeroController::class);
    Route::get('page-hero-global/settings', [App\Http\Controllers\Admin\PageHeroController::class, 'globalSettings'])->name('page-hero.global-settings');
    Route::post('page-hero-global/settings', [App\Http\Controllers\Admin\PageHeroController::class, 'updateGlobalSettings'])->name('page-hero.update-global-settings');
    
    // Services
    Route::resource('services', App\Http\Controllers\Admin\ServiceController::class);
    
    // Projects
    Route::resource('projects', App\Http\Controllers\Admin\ProjectController::class);
    
    // Products
    Route::resource('products', App\Http\Controllers\Admin\ProductController::class);
    Route::post('products/bulk-action', [App\Http\Controllers\Admin\ProductController::class, 'bulkAction'])->name('products.bulk-action');
    
    // Product Categories
    Route::resource('product-categories', App\Http\Controllers\Admin\ProductCategoryController::class);
    
    // Articles
    Route::resource('articles', App\Http\Controllers\Admin\ArticleController::class);
    
    // Article Categories
    Route::resource('article-categories', App\Http\Controllers\Admin\ArticleCategoryController::class);
    
    // Teams
    Route::resource('teams', App\Http\Controllers\Admin\TeamController::class);
    
    // Why Choose Us
    Route::resource('why-choose-us', App\Http\Controllers\Admin\WhyChooseUsController::class);
    
    // Testimonials
    Route::resource('testimonials', App\Http\Controllers\Admin\TestimonialController::class);
    
    // Job Listings
    Route::resource('jobs', App\Http\Controllers\Admin\JobListingController::class);
    
    // Job Applications
    Route::resource('job-applications', App\Http\Controllers\Admin\JobApplicationController::class);
    Route::patch('job-applications/{jobApplication}/status', [App\Http\Controllers\Admin\JobApplicationController::class, 'updateStatus'])->name('job-applications.update-status');
    
    // Messages
    Route::get('messages', [App\Http\Controllers\Admin\MessageController::class, 'index'])->name('messages.index');
    Route::get('messages/{message}', [App\Http\Controllers\Admin\MessageController::class, 'show'])->name('messages.show');
    Route::delete('messages/{message}', [App\Http\Controllers\Admin\MessageController::class, 'destroy'])->name('messages.destroy');
    Route::patch('messages/{message}/mark-read', [App\Http\Controllers\Admin\MessageController::class, 'markAsRead'])->name('messages.mark-read');
    
    // Menu Management
    Route::get('menus', [App\Http\Controllers\Admin\MenuController::class, 'index'])->name('menus.index');
    Route::patch('menus/{menu}/visibility', [App\Http\Controllers\Admin\MenuController::class, 'updateVisibility'])->name('menus.update-visibility');
    Route::post('menus/update-order', [App\Http\Controllers\Admin\MenuController::class, 'updateOrder'])->name('menus.update-order');
    Route::post('menus/update-icon-settings', [App\Http\Controllers\Admin\MenuController::class, 'updateIconSettings'])->name('menus.update-icon-settings');
    Route::post('menus/update-settings', [App\Http\Controllers\Admin\MenuController::class, 'updateSettings'])->name('menus.update-settings');
    Route::get('menus/data', [App\Http\Controllers\Admin\MenuController::class, 'getMenuData'])->name('menus.data');
    Route::post('menus/reset', [App\Http\Controllers\Admin\MenuController::class, 'reset'])->name('menus.reset');
    
    // Profile
    Route::get('profile', [App\Http\Controllers\Admin\ProfileController::class, 'show'])->name('profile.show');
    Route::get('profile/edit', [App\Http\Controllers\Admin\ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('profile', [App\Http\Controllers\Admin\ProfileController::class, 'update'])->name('profile.update');
    Route::get('profile/password', [App\Http\Controllers\Admin\ProfileController::class, 'editPassword'])->name('profile.edit-password');
    Route::put('profile/password', [App\Http\Controllers\Admin\ProfileController::class, 'updatePassword'])->name('profile.update-password');
    Route::delete('profile/avatar', [App\Http\Controllers\Admin\ProfileController::class, 'removeAvatar'])->name('profile.remove-avatar');
    
    // Visitor Chart Data (AJAX)
    Route::get('visitor-chart-data', [App\Http\Controllers\Admin\DashboardController::class, 'getVisitorChartData'])->name('visitor-chart-data');
});
