@extends('layouts.admin')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')
@section('page-description', 'Ringkasan data dan statistik website')

@section('content')
<div class="space-y-8">
    <!-- Welcome Card -->
    <div class="bg-gradient-to-r from-blue-600 to-purple-600 rounded-2xl shadow-xl p-8 text-white">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold mb-2">Selamat Datang, {{ Auth::user()->name }}!</h1>
                <p class="text-blue-100">Kelola konten website perusahaan Anda dengan mudah</p>
            </div>
            <div class="hidden md:block">
                <div class="w-24 h-24 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-sm">
                    <i class="fas fa-crown text-4xl text-white"></i>
                </div>
            </div>
        </div>
    </div>
    <!-- Statistics Cards (rapi, tidak duplikat) -->
    <div class="grid grid-cols-1 md:grid-cols-4 lg:grid-cols-5 gap-6">
        <!-- Services -->
        <div class="bg-white rounded-xl shadow-lg p-6 border border-gray-100 hover:shadow-xl transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Total Layanan</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $stats['services'] }}</p>
                    <p class="text-sm text-blue-600 mt-1">
                        <i class="fas fa-cogs mr-1"></i>Layanan aktif
                    </p>
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-cogs text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>
        
        <!-- Projects -->
        <div class="bg-white rounded-xl shadow-lg p-6 border border-gray-100 hover:shadow-xl transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Total Proyek</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $stats['projects'] }}</p>
                    <p class="text-sm text-green-600 mt-1">
                        <i class="fas fa-folder mr-1"></i>Portofolio
                    </p>
                </div>
                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-folder text-green-600 text-xl"></i>
                </div>
            </div>
        </div>
        
        <!-- Articles -->
        <div class="bg-white rounded-xl shadow-lg p-6 border border-gray-100 hover:shadow-xl transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Total Artikel</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $stats['articles'] }}</p>
                    <p class="text-sm text-purple-600 mt-1">
                        <i class="fas fa-newspaper mr-1"></i>Konten blog
                    </p>
                </div>
                <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-newspaper text-purple-600 text-xl"></i>
                </div>
            </div>
        </div>
        
        <!-- Messages -->
        <div class="bg-white rounded-xl shadow-lg p-6 border border-gray-100 hover:shadow-xl transition-shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Pesan Baru</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $stats['messages'] }}</p>
                    <p class="text-sm text-orange-600 mt-1">
                        <i class="fas fa-envelope mr-1"></i>Belum dibaca
                    </p>
                </div>
                <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-envelope text-orange-600 text-xl"></i>
                </div>
            </div>
        </div> 
    </div>

    <!-- Recent Activity & Quick Actions -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Recent Activity -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-100">
            <div class="p-6 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                    <i class="fas fa-clock mr-2 text-gray-500"></i>
                    Aktivitas Terkini
                </h3>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    <div class="flex items-start space-x-3">
                        <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                            <i class="fas fa-plus text-blue-600 text-xs"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm text-gray-800">Layanan baru "Web Development" ditambahkan</p>
                            <p class="text-xs text-gray-500 mt-1">2 jam yang lalu</p>
                        </div>
                    </div>
                    <div class="flex items-start space-x-3">
                        <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                            <i class="fas fa-edit text-green-600 text-xs"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm text-gray-800">Artikel "Tips SEO" diperbarui</p>
                            <p class="text-xs text-gray-500 mt-1">5 jam yang lalu</p>
                        </div>
                    </div>
                    <div class="flex items-start space-x-3">
                        <div class="w-8 h-8 bg-purple-100 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                            <i class="fas fa-envelope text-purple-600 text-xs"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm text-gray-800">Pesan baru diterima dari John Doe</p>
                            <p class="text-xs text-gray-500 mt-1">1 hari yang lalu</p>
                        </div>
                    </div>
                    <div class="flex items-start space-x-3">
                        <div class="w-8 h-8 bg-yellow-100 rounded-full flex items-center justify-center flex-shrink-0 mt-1">
                            <i class="fas fa-star text-yellow-600 text-xs"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm text-gray-800">Testimoni baru dari PT. ABC</p>
                            <p class="text-xs text-gray-500 mt-1">2 hari yang lalu</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-100">
            <div class="p-6 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                    <i class="fas fa-bolt mr-2 text-gray-500"></i>
                    Aksi Cepat
                </h3>
            </div>
            <div class="p-6">
                <div class="grid grid-cols-2 gap-4">
                    <a href="{{ route('admin.services.create') }}" 
                       class="p-4 border-2 border-dashed border-blue-300 rounded-lg hover:border-blue-500 hover:bg-blue-50 transition-colors group">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mx-auto mb-2 group-hover:bg-blue-200 transition-colors">
                                <i class="fas fa-plus text-blue-600 text-lg"></i>
                            </div>
                            <p class="text-sm font-medium text-gray-700">Tambah Layanan</p>
                        </div>
                    </a>
                    <a href="{{ route('admin.projects.create') }}" 
                       class="p-4 border-2 border-dashed border-green-300 rounded-lg hover:border-green-500 hover:bg-green-50 transition-colors group">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-2 group-hover:bg-green-200 transition-colors">
                                <i class="fas fa-folder-plus text-green-600 text-lg"></i>
                            </div>
                            <p class="text-sm font-medium text-gray-700">Tambah Proyek</p>
                        </div>
                    </a>
                    <a href="{{ route('admin.articles.create') }}" 
                       class="p-4 border-2 border-dashed border-purple-300 rounded-lg hover:border-purple-500 hover:bg-purple-50 transition-colors group">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mx-auto mb-2 group-hover:bg-purple-200 transition-colors">
                                <i class="fas fa-pen text-purple-600 text-lg"></i>
                            </div>
                            <p class="text-sm font-medium text-gray-700">Tulis Artikel</p>
                        </div>
                    </a>
                    <a href="{{ route('admin.messages.index') }}" 
                       class="p-4 border-2 border-dashed border-red-300 rounded-lg hover:border-red-500 hover:bg-red-50 transition-colors group">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mx-auto mb-2 group-hover:bg-red-200 transition-colors">
                                <i class="fas fa-inbox text-red-600 text-lg"></i>
                            </div>
                            <p class="text-sm font-medium text-gray-700">Lihat Pesan</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Chart Section -->
    <div class="bg-white rounded-xl shadow-lg border border-gray-100">
        <div class="p-6 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                    <i class="fas fa-chart-line mr-2 text-gray-500"></i>
                    Statistik Kunjungan Website
                </h3>
                <div class="flex items-center space-x-2">
                    <span class="text-sm text-gray-600">Total Kunjungan Hari Ini:</span>
                    <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded-full text-sm font-medium">
                        {{ $stats['today_visitors'] }}
                    </span>
                </div>
            </div>
        </div>
        <div class="p-6">
            <!-- Chart Controls -->
            <div class="mb-6">
                <div class="flex flex-wrap items-center gap-4">
                    <!-- Quick Actions -->
                    <div class="flex items-center space-x-2">
                        <button type="button" onclick="loadChartData('1month')" 
                                class="px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600 transition-colors text-sm">
                            1 Bulan
                        </button>
                        <button type="button" onclick="loadChartData('2months')" 
                                class="px-4 py-2 bg-green-500 text-white rounded-lg hover:bg-green-600 transition-colors text-sm">
                            2 Bulan
                        </button>
                        <button type="button" onclick="loadChartData('3months')" 
                                class="px-4 py-2 bg-purple-500 text-white rounded-lg hover:bg-purple-600 transition-colors text-sm">
                            3 Bulan
                        </button>
                    </div>
                    
                    <!-- Custom Date Range -->
                    <div class="flex items-center space-x-2">
                        <input type="date" id="start_date" 
                               class="px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent text-sm"
                               value="{{ date('Y-m-d', strtotime('-30 days')) }}">
                        <span class="text-gray-500">s/d</span>
                        <input type="date" id="end_date" 
                               class="px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent text-sm"
                               value="{{ date('Y-m-d') }}">
                        <button type="button" onclick="loadChartData('custom')" 
                                class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition-colors text-sm">
                            Filter
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Chart Container -->
            <div class="relative">
                <canvas id="visitorsChart" width="400" height="150"></canvas>
                
                <!-- Loading Spinner -->
                <div id="chartLoading" class="absolute inset-0 flex items-center justify-center bg-white/80 rounded-lg">
                    <div class="text-center">
                        <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-blue-500 mx-auto"></div>
                        <p class="text-sm text-gray-600 mt-2">Memuat data...</p>
                    </div>
                </div>
            </div>
            
            <!-- Chart Stats -->
            <div class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="bg-blue-50 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-blue-600">Total Kunjungan</p>
                            <p class="text-2xl font-bold text-blue-800" id="totalVisitors">-</p>
                        </div>
                        <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-users text-blue-600"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-green-50 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-green-600">Rata-rata Harian</p>
                            <p class="text-2xl font-bold text-green-800" id="avgVisitors">-</p>
                        </div>
                        <div class="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-chart-line text-green-600"></i>
                        </div>
                    </div>
                </div>
                
                <div class="bg-purple-50 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-purple-600">Hari Ini</p>
                            <p class="text-2xl font-bold text-purple-800">{{ $stats['today_visitors'] }}</p>
                        </div>
                        <div class="w-10 h-10 bg-purple-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-calendar-day text-purple-600"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Visitors Chart
    let visitorsChart = null;
    
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize chart
        const ctx = document.getElementById('visitorsChart').getContext('2d');
        visitorsChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'Kunjungan Harian',
                    data: [],
                    borderColor: 'rgb(59, 130, 246)',
                    backgroundColor: 'rgba(59, 130, 246, 0.1)',
                    borderWidth: 2,
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
        
        // Load default data (1 month)
        loadChartData('1month');
    });
    
    function loadChartData(type) {
        const loading = document.getElementById('chartLoading');
        loading.style.display = 'flex';
        
        let url = '{{ route("admin.visitor-chart-data") }}?type=' + type;
        
        if (type === 'custom') {
            const startDate = document.getElementById('start_date').value;
            const endDate = document.getElementById('end_date').value;
            url += '&start_date=' + startDate + '&end_date=' + endDate;
        }
        
        fetch(url)
            .then(response => response.json())
            .then(data => {
                // Update chart
                visitorsChart.data.labels = data.labels;
                visitorsChart.data.datasets[0].data = data.data;
                visitorsChart.update();
                
                // Update stats
                document.getElementById('totalVisitors').textContent = data.total;
                document.getElementById('avgVisitors').textContent = data.data.length > 0 ? 
                    Math.round(data.total / data.data.length) : 0;
                
                loading.style.display = 'none';
            })
            .catch(error => {
                console.error('Error loading chart data:', error);
                loading.style.display = 'none';
                alert('Gagal memuat data chart. Silakan coba lagi.');
            });
    }
    
    // Dashboard interactive features
    console.log('Dashboard loaded successfully');
</script>
@endpush
