@extends('layouts.admin')

@section('title', 'Kelola Menu')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">Kelola Menu Website</h1>
                <p class="mt-1 text-sm text-gray-600">Atur tampilan dan urutan menu navigasi website</p>
            </div>
            <div class="mt-4 sm:mt-0 flex space-x-3">
                <button onclick="openIconModal()" 
                        class="inline-flex items-center px-4 py-2 border border-purple-300 rounded-lg text-sm font-medium text-purple-700 bg-white hover:bg-purple-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 transition duration-150 ease-in-out">
                    <i class="fas fa-eye mr-2"></i>
                    Atur Icon
                </button>
                <button onclick="resetMenu()" 
                        class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                    <i class="fas fa-undo mr-2"></i>
                    Reset Default
                </button>
                <button onclick="saveMenuOrder()" 
                        class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-lg text-sm font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                    <i class="fas fa-save mr-2"></i>
                    Simpan Urutan
                </button>
            </div>
        </div>
    </div>

    <!-- Instructions -->
    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-info-circle text-blue-400"></i>
            </div>
            <div class="ml-3">
                <p class="text-sm text-blue-700">
                    <strong>Cara Penggunaan:</strong>
                </p>
                <ul class="mt-2 text-sm text-blue-600 list-disc list-inside space-y-1">
                    <li>Seret dan lepas menu untuk mengubah urutan</li>
                    <li>Seret menu ke dalam menu lain untuk membuat submenu</li>
                    <li>Gunakan toggle untuk menampilkan/menyembunyikan menu</li>
                    <li>Menu "Beranda" tidak dapat disembunyikan karena merupakan menu sistem</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Menu Management -->
    <div class="bg-white shadow-sm border border-gray-200 rounded-lg">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg leading-6 font-medium text-gray-900">
                <i class="fas fa-bars mr-2"></i>
                Struktur Menu
            </h3>
        </div>
        <div class="p-6">
            <div id="menu-container">
                <ul id="menu-list" class="space-y-2">
                    @foreach($menuItems as $menu)
                        <li class="menu-item" data-id="{{ $menu->id }}" data-parent-id="{{ $menu->parent_id }}">
                            <div class="flex items-center justify-between p-4 bg-gray-50 border border-gray-200 rounded-lg hover:bg-gray-100 transition-colors cursor-move">
                                <div class="flex items-center space-x-4">
                                    <div class="drag-handle text-gray-400 hover:text-gray-600">
                                        <i class="fas fa-grip-vertical"></i>
                                    </div>
                                    <div class="flex items-center space-x-3">
                                        @if($menu->icon)
                                            <i class="{{ $menu->icon }} text-gray-600"></i>
                                        @endif
                                        <div>
                                            <h4 class="text-sm font-medium text-gray-900">{{ $menu->title }}</h4>
                                            <p class="text-xs text-gray-500">{{ $menu->description }}</p>
                                        </div>
                                    </div>
                                    @if($menu->is_system)
                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800">
                                            <i class="fas fa-shield-alt mr-1"></i>
                                            Sistem
                                        </span>
                                    @endif
                                </div>
                                <div class="flex items-center space-x-4">
                                    <div class="flex items-center">
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" 
                                                   class="sr-only peer visibility-toggle" 
                                                   data-menu-id="{{ $menu->id }}"
                                                   {{ $menu->is_visible ? 'checked' : '' }}
                                                   {{ $menu->is_system ? 'disabled' : '' }}>
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600 {{ $menu->is_system ? 'opacity-50 cursor-not-allowed' : '' }}"></div>
                                        </label>
                                        <span class="ml-3 text-sm text-gray-900">
                                            {{ $menu->is_visible ? 'Tampil' : 'Tersembunyi' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            @if($menu->children->count() > 0)
                                <ul class="ml-8 mt-2 space-y-2">
                                    @foreach($menu->children as $child)
                                        <li class="menu-item" data-id="{{ $child->id }}" data-parent-id="{{ $child->parent_id }}">
                                            <div class="flex items-center justify-between p-3 bg-gray-25 border border-gray-150 rounded-lg hover:bg-gray-50 transition-colors cursor-move">
                                                <div class="flex items-center space-x-4">
                                                    <div class="drag-handle text-gray-400 hover:text-gray-600">
                                                        <i class="fas fa-grip-vertical text-sm"></i>
                                                    </div>
                                                    <div class="flex items-center space-x-3">
                                                        @if($child->icon)
                                                            <i class="{{ $child->icon }} text-gray-500 text-sm"></i>
                                                        @endif
                                                        <div>
                                                            <h5 class="text-sm font-medium text-gray-800">{{ $child->title }}</h5>
                                                            <p class="text-xs text-gray-500">{{ $child->description }}</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="flex items-center space-x-4">
                                                    <div class="flex items-center">
                                                        <label class="relative inline-flex items-center cursor-pointer">
                                                            <input type="checkbox" 
                                                                   class="sr-only peer visibility-toggle" 
                                                                   data-menu-id="{{ $child->id }}"
                                                                   {{ $child->is_visible ? 'checked' : '' }}>
                                                            <div class="w-9 h-5 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[1px] after:left-[1px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-4 after:w-4 after:transition-all peer-checked:bg-blue-600"></div>
                                                        </label>
                                                        <span class="ml-2 text-xs text-gray-800">
                                                            {{ $child->is_visible ? 'Tampil' : 'Tersembunyi' }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </li>
                    @endforeach
                </ul>
            </div>
            
            <div class="mt-6 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle text-yellow-400"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-yellow-700">
                            <strong>Perhatian:</strong> Perubahan urutan menu akan otomatis tersimpan saat Anda seret dan lepas. 
                            Perubahan visibility akan tersimpan otomatis saat toggle diubah.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reset Confirmation Modal -->
<div id="resetModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-yellow-100">
                <i class="fas fa-exclamation-triangle text-yellow-600 text-xl"></i>
            </div>
            <div class="mt-3 text-center">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Reset Menu ke Default</h3>
                <div class="mt-2 px-7 py-3">
                    <p class="text-sm text-gray-500">
                        Apakah Anda yakin ingin mereset semua pengaturan menu ke pengaturan default?
                        <br><br>
                        <span class="text-yellow-600">Semua perubahan urutan dan visibility akan dikembalikan ke pengaturan awal.</span>
                    </p>
                </div>
                <div class="flex justify-center space-x-4 px-7 py-3">
                    <button type="button" onclick="closeResetModal()"
                            class="px-4 py-2 bg-gray-300 text-gray-800 text-sm font-medium rounded-md hover:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-300">
                        Batal
                    </button>
                    <form id="reset-form" action="{{ route('admin.menus.reset') }}" method="POST" class="inline">
                        @csrf
                        <button type="submit"
                                class="px-4 py-2 bg-yellow-600 text-white text-sm font-medium rounded-md hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-yellow-500">
                            Reset
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Icon Settings Modal -->
<div id="iconModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden">
    <div class="relative top-10 mx-auto p-5 border w-3/4 max-w-4xl shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg leading-6 font-medium text-gray-900">
                    <i class="fas fa-eye mr-2 text-purple-600"></i>
                    Pengaturan Tampilan Icon Menu
                </h3>
                <button onclick="closeIconModal()" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <div class="mb-4">
                <p class="text-sm text-gray-600">
                    Pilih menu mana yang akan menampilkan icon dan mana yang tidak. Perubahan akan langsung terlihat di website.
                </p>
            </div>
            
            <div class="max-h-96 overflow-y-auto border border-gray-200 rounded-lg">
                <div id="iconSettingsList" class="divide-y divide-gray-200">
                    <!-- Icon settings akan di-load di sini via JavaScript -->
                </div>
            </div>
            
            <div class="flex justify-between items-center mt-6 pt-4 border-t border-gray-200">
                <div class="flex space-x-3">
                    <button onclick="toggleAllIcons(true)" 
                            class="px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500">
                        <i class="fas fa-check-circle mr-1"></i>
                        Tampilkan Semua
                    </button>
                    <button onclick="toggleAllIcons(false)" 
                            class="px-4 py-2 bg-red-600 text-white text-sm font-medium rounded-md hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-500">
                        <i class="fas fa-times-circle mr-1"></i>
                        Sembunyikan Semua
                    </button>
                </div>
                <div class="flex space-x-3">
                    <button onclick="closeIconModal()" 
                            class="px-4 py-2 bg-gray-300 text-gray-800 text-sm font-medium rounded-md hover:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-300">
                        Batal
                    </button>
                    <button onclick="saveIconSettings()" 
                            class="px-4 py-2 bg-purple-600 text-white text-sm font-medium rounded-md hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500">
                        <i class="fas fa-save mr-1"></i>
                        Simpan Pengaturan
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Include SortableJS -->
<script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize sortable for main menu
    const menuList = document.getElementById('menu-list');
    const sortable = Sortable.create(menuList, {
        group: {
            name: 'menu',
            pull: true,
            put: function(to, from, dragEl) {
                // Don't allow nesting more than 2 levels
                if (to.el.closest('.menu-item')) {
                    return false;
                }
                return true;
            }
        },
        animation: 150,
        handle: '.drag-handle',
        ghostClass: 'sortable-ghost',
        chosenClass: 'sortable-chosen',
        dragClass: 'sortable-drag',
        filter: '.no-drag',
        preventOnFilter: false,
        onEnd: function(evt) {
            updateMenuOrder();
        }
    });

    // Initialize sortable for existing submenus
    initializeSubmenus();

    // Handle visibility toggle
    document.querySelectorAll('.visibility-toggle').forEach(function(toggle) {
        toggle.addEventListener('change', function() {
            const menuId = this.dataset.menuId;
            const isVisible = this.checked;
            
            updateVisibility(menuId, isVisible);
        });
    });
});

function initializeSubmenus() {
    document.querySelectorAll('#menu-list ul').forEach(function(submenu) {
        if (!submenu.sortableInstance) {
            submenu.sortableInstance = Sortable.create(submenu, {
                group: {
                    name: 'submenu',
                    pull: true,
                    put: true
                },
                animation: 150,
                handle: '.drag-handle',
                ghostClass: 'sortable-ghost',
                chosenClass: 'sortable-chosen',
                dragClass: 'sortable-drag',
                onEnd: function(evt) {
                    updateMenuOrder();
                }
            });
        }
    });
}

function updateMenuOrder() {
    const items = [];
    let sortOrder = 1;

    document.querySelectorAll('#menu-list > .menu-item').forEach(function(item) {
        const id = item.dataset.id;
        items.push({
            id: parseInt(id),
            sort_order: sortOrder++,
            parent_id: null
        });

        // Handle submenus
        let subSortOrder = 1;
        const submenuContainer = item.querySelector('ul');
        if (submenuContainer) {
            submenuContainer.querySelectorAll('.menu-item').forEach(function(subItem) {
                const subId = subItem.dataset.id;
                items.push({
                    id: parseInt(subId),
                    sort_order: subSortOrder++,
                    parent_id: parseInt(id)
                });
                // Update the data attribute
                subItem.dataset.parentId = id;
            });
        }
    });

    // Send AJAX request to update order
    fetch('{{ route("admin.menus.update-order") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ items: items })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('success', data.message);
            // Reinitialize submenus after order change
            setTimeout(() => {
                initializeSubmenus();
            }, 100);
        } else {
            showNotification('error', data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('error', 'Terjadi kesalahan saat memperbarui urutan menu');
    });
}

function updateVisibility(menuId, isVisible) {
    fetch(`{{ url('admin/menus') }}/${menuId}/visibility`, {
        method: 'PATCH',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ is_visible: isVisible })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification('success', data.message);
            
            // Update visibility text
            const toggle = document.querySelector(`[data-menu-id="${menuId}"]`);
            const visibilityText = toggle.closest('.flex').querySelector('span:last-child');
            visibilityText.textContent = isVisible ? 'Tampil' : 'Tersembunyi';
        } else {
            showNotification('error', data.message);
            // Revert toggle if failed
            document.querySelector(`[data-menu-id="${menuId}"]`).checked = !isVisible;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('error', 'Terjadi kesalahan saat mengubah visibility menu');
        // Revert toggle if failed
        document.querySelector(`[data-menu-id="${menuId}"]`).checked = !isVisible;
    });
}

function saveMenuOrder() {
    updateMenuOrder();
}

function resetMenu() {
    document.getElementById('resetModal').classList.remove('hidden');
}

function closeResetModal() {
    document.getElementById('resetModal').classList.add('hidden');
}

function showNotification(type, message) {
    // Remove any existing notifications
    const existingNotification = document.querySelector('.notification-popup');
    if (existingNotification) {
        existingNotification.remove();
    }

    // Create simple notification element
    const notification = document.createElement('div');
    notification.className = `notification-popup fixed top-4 right-4 z-50 px-4 py-3 rounded-lg shadow-lg text-white text-sm font-medium transition-all duration-300 transform translate-x-full opacity-0 ${type === 'success' ? 'bg-green-500' : 'bg-red-500'}`;
    
    // Add icon and message
    const icon = type === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-circle';
    notification.innerHTML = `
        <div class="flex items-center">
            <i class="${icon} mr-2"></i>
            <span>${message}</span>
        </div>
    `;

    document.body.appendChild(notification);

    // Animate in
    setTimeout(() => {
        notification.classList.remove('translate-x-full', 'opacity-0');
    }, 100);

    // Auto remove after 3 seconds
    setTimeout(() => {
        notification.classList.add('translate-x-full', 'opacity-0');
        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 300);
    }, 3000);
}

// Close modal when clicking outside
document.getElementById('resetModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeResetModal();
    }
});

// Close icon modal when clicking outside
document.getElementById('iconModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeIconModal();
    }
});

// Close modal on escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeResetModal();
        closeIconModal();
    }
});

// Icon Modal Functions
let menuData = [];

function openIconModal() {
    document.getElementById('iconModal').classList.remove('hidden');
    loadIconSettings();
}

function closeIconModal() {
    document.getElementById('iconModal').classList.add('hidden');
}

function loadIconSettings() {
    fetch('{{ route("admin.menus.data") }}')
        .then(response => response.json())
        .then(data => {
            menuData = data;
            renderIconSettings(data);
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('Gagal memuat data menu', 'error');
        });
}

function renderIconSettings(data) {
    const container = document.getElementById('iconSettingsList');
    container.innerHTML = '';
    
    data.forEach(menu => {
        if (menu.parent_id === null) { // Main menu only
            const menuItem = createIconSettingItem(menu);
            container.appendChild(menuItem);
            
            // Add children if exists
            const children = data.filter(item => item.parent_id === menu.id);
            if (children.length > 0) {
                children.forEach(child => {
                    const childItem = createIconSettingItem(child, true);
                    container.appendChild(childItem);
                });
            }
        }
    });
}

function createIconSettingItem(menu, isChild = false) {
    const div = document.createElement('div');
    div.className = `p-4 ${isChild ? 'bg-gray-50 ml-8' : 'bg-white'} hover:bg-gray-100 transition-colors`;
    div.dataset.menuId = menu.id;
    
    div.innerHTML = `
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-3">
                ${isChild ? '<i class="fas fa-arrow-right text-gray-400 text-sm mr-2"></i>' : ''}
                ${menu.icon ? `<i class="${menu.icon} text-gray-600"></i>` : '<i class="fas fa-circle text-gray-300"></i>'}
                <div>
                    <h4 class="text-sm font-medium text-gray-900">${menu.title}</h4>
                    <p class="text-xs text-gray-500">${menu.icon || 'Tidak ada icon'}</p>
                </div>
            </div>
            <div class="flex items-center space-x-3">
                <span class="text-sm text-gray-600 icon-status">
                    ${menu.show_icon ? 'Tampil' : 'Tersembunyi'}
                </span>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           class="sr-only peer icon-toggle" 
                           data-menu-id="${menu.id}"
                           ${menu.show_icon ? 'checked' : ''}
                           ${!menu.icon ? 'disabled' : ''}>
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-purple-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-purple-600 ${!menu.icon ? 'opacity-50 cursor-not-allowed' : ''}"></div>
                </label>
            </div>
        </div>
    `;
    
    // Add event listener for toggle
    const toggle = div.querySelector('.icon-toggle');
    if (toggle && !toggle.disabled) {
        toggle.addEventListener('change', function() {
            updateIconToggleText(this);
        });
    }
    
    return div;
}

function updateIconToggleText(toggle) {
    const menuItem = toggle.closest('[data-menu-id]');
    const statusText = menuItem.querySelector('.icon-status');
    statusText.textContent = toggle.checked ? 'Tampil' : 'Tersembunyi';
}

function toggleAllIcons(show) {
    const toggles = document.querySelectorAll('.icon-toggle:not([disabled])');
    toggles.forEach(toggle => {
        toggle.checked = show;
        updateIconToggleText(toggle);
    });
}

function saveIconSettings() {
    const toggles = document.querySelectorAll('.icon-toggle');
    const items = [];
    
    toggles.forEach(toggle => {
        items.push({
            id: parseInt(toggle.dataset.menuId),
            show_icon: toggle.checked
        });
    });
    
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    
    fetch('{{ route("admin.menus.update-icon-settings") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrfToken
        },
        body: JSON.stringify({ items: items })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification(data.message, 'success');
            closeIconModal();
            // Reload page to see changes
            setTimeout(() => {
                window.location.reload();
            }, 1000);
        } else {
            showNotification(data.message || 'Terjadi kesalahan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('Terjadi kesalahan saat menyimpan pengaturan', 'error');
    });
}
            <div class="flex items-center">
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" 
                           class="sr-only peer icon-toggle" 
                           data-menu-id="${menu.id}"
                           ${menu.show_icon ? 'checked' : ''}>
                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-purple-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-purple-600"></div>
                </label>
                <span class="ml-3 text-sm text-gray-900">
                    ${menu.show_icon ? 'Tampil' : 'Sembunyikan'}
                </span>
            </div>
        </div>
    `;
    
    // Add event listener for toggle
    const toggle = div.querySelector('.icon-toggle');
    toggle.addEventListener('change', function() {
        const span = div.querySelector('span');
        span.textContent = this.checked ? 'Tampil' : 'Sembunyikan';
        
        // Update menuData
        const menuItem = menuData.find(item => item.id == this.dataset.menuId);
        if (menuItem) {
            menuItem.show_icon = this.checked;
        }
    });
    
    return div;
}

function toggleAllIcons(show) {
    document.querySelectorAll('.icon-toggle').forEach(toggle => {
        toggle.checked = show;
        toggle.dispatchEvent(new Event('change'));
    });
}

function saveIconSettings() {
    const items = menuData.map(menu => ({
        id: menu.id,
        show_icon: menu.show_icon
    }));
    
    fetch('{{ route("admin.menus.update-icon-settings") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ items: items })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showNotification(data.message, 'success');
            closeIconModal();
            // Reload page to reflect changes
            setTimeout(() => {
                window.location.reload();
            }, 1500);
        } else {
            showNotification(data.message, 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('Terjadi kesalahan saat menyimpan pengaturan', 'error');
    });
}
</script>

<style>
.sortable-ghost {
    opacity: 0.4;
    background: #e5e7eb;
}

.sortable-chosen {
    cursor: grabbing;
    background: #dbeafe;
    border-color: #3b82f6;
}

.sortable-drag {
    transform: rotate(5deg);
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
}

.menu-item:hover .drag-handle {
    color: #4B5563;
}

.menu-item .drag-handle {
    cursor: grab;
    transition: color 0.2s ease;
}

.menu-item .drag-handle:active {
    cursor: grabbing;
}

/* Submenu styling */
.menu-item ul {
    border-left: 2px solid #e5e7eb;
    margin-left: 1rem;
    padding-left: 1rem;
}

.menu-item ul .menu-item {
    position: relative;
}

.menu-item ul .menu-item::before {
    content: '';
    position: absolute;
    left: -1rem;
    top: 50%;
    width: 0.75rem;
    height: 2px;
    background: #e5e7eb;
}

/* Drop zone indicators */
.sortable-drop-zone {
    background: #dbeafe;
    border: 2px dashed #3b82f6;
    min-height: 3rem;
    border-radius: 0.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #3b82f6;
    font-size: 0.875rem;
    margin: 0.25rem 0;
}
</style>

@endsection
