@extends('layouts.admin')

@section('title', 'Tambah Produk')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">Tambah Produk</h1>
                <p class="mt-1 text-sm text-gray-600">Tambahkan produk baru ke dalam sistem</p>
            </div>
            <div class="mt-4 sm:mt-0">
                <a href="{{ route('admin.products.index') }}" 
                   class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Kembali
                </a>
            </div>
        </div>
    </div>

    <!-- Form -->
    <form action="{{ route('admin.products.store') }}" method="POST" enctype="multipart/form-data" class="space-y-8">
        @csrf
        
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Main Content -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Basic Information -->
                <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900">Informasi Dasar</h3>
                    </div>
                    <div class="px-6 py-4 space-y-6">
                        <!-- Product Name -->
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Nama Produk *</label>
                            <input type="text" name="name" id="name" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('name') border-red-500 @enderror"
                                   value="{{ old('name') }}" placeholder="Masukkan nama produk">
                            @error('name')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Slug -->
                        <div>
                            <label for="slug" class="block text-sm font-medium text-gray-700 mb-2">Slug</label>
                            <input type="text" name="slug" id="slug"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('slug') border-red-500 @enderror"
                                   value="{{ old('slug') }}" placeholder="URL-friendly name">
                            <p class="mt-1 text-xs text-gray-500">Kosongkan untuk generate otomatis dari nama produk</p>
                            @error('slug')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Category and Brand -->
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div>
                                <label for="product_category_id" class="block text-sm font-medium text-gray-700 mb-2">Kategori *</label>
                                <select name="product_category_id" id="product_category_id" required
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('product_category_id') border-red-500 @enderror">
                                    <option value="">Pilih Kategori</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ old('product_category_id') == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('product_category_id')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="brand" class="block text-sm font-medium text-gray-700 mb-2">Brand</label>
                                <input type="text" name="brand" id="brand"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('brand') border-red-500 @enderror"
                                       value="{{ old('brand') }}" placeholder="Nama brand/merek">
                                @error('brand')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Short Description -->
                        <div>
                            <label for="short_description" class="block text-sm font-medium text-gray-700 mb-2">Deskripsi Singkat</label>
                            <textarea name="short_description" id="short_description" rows="3"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('short_description') border-red-500 @enderror"
                                      placeholder="Deskripsi singkat produk">{{ old('short_description') }}</textarea>
                            @error('short_description')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Description -->
                        <div>
                            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Deskripsi Lengkap *</label>
                            <textarea name="description" id="description" rows="6" required
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('description') border-red-500 @enderror"
                                      placeholder="Deskripsi lengkap produk">{{ old('description') }}</textarea>
                            @error('description')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Specifications -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Spesifikasi</label>
                            <div id="specifications-container" class="space-y-3">
                                <!-- Default specification row -->
                                <div class="specification-row flex gap-2">
                                    <input type="text" name="specifications[0][key]" placeholder="Nama spesifikasi"
                                           class="flex-1 px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <input type="text" name="specifications[0][value]" placeholder="Nilai spesifikasi"
                                           class="flex-1 px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <button type="button" class="remove-specification px-3 py-2 text-red-600 hover:text-red-800 hover:bg-red-50 rounded-lg transition duration-150 ease-in-out">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                            <button type="button" id="add-specification" 
                                    class="mt-3 inline-flex items-center px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                                <i class="fas fa-plus mr-2"></i>
                                Tambah Spesifikasi
                            </button>
                            @error('specifications')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Condition -->
                        <div>
                            <label for="condition" class="block text-sm font-medium text-gray-700 mb-2">Kondisi *</label>
                            <select name="condition" id="condition" required
                                    class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('condition') border-red-500 @enderror">
                                <option value="">Pilih Kondisi</option>
                                <option value="new" {{ old('condition') == 'new' ? 'selected' : '' }}>Baru</option>
                                <option value="used" {{ old('condition') == 'used' ? 'selected' : '' }}>Bekas</option>
                                <option value="refurbished" {{ old('condition') == 'refurbished' ? 'selected' : '' }}>Refurbished</option>
                            </select>
                            @error('condition')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Pricing & Inventory -->
                <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900">Harga & Stok</h3>
                    </div>
                    <div class="px-6 py-4 space-y-6">
                        <!-- Price & Discount -->
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div>
                                <label for="price" class="block text-sm font-medium text-gray-700 mb-2">Harga Normal *</label>
                                <input type="number" name="price" id="price" step="0.01" min="0" required
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('price') border-red-500 @enderror"
                                       value="{{ old('price') }}" placeholder="0">
                                @error('price')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label for="discount_price" class="block text-sm font-medium text-gray-700 mb-2">Harga Diskon</label>
                                <input type="number" name="discount_price" id="discount_price" step="0.01" min="0"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('discount_price') border-red-500 @enderror"
                                       value="{{ old('discount_price') }}" placeholder="0">
                                @error('discount_price')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Stock & SKU -->
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div>
                                <label for="stock" class="block text-sm font-medium text-gray-700 mb-2">Stok *</label>
                                <input type="number" name="stock" id="stock" min="0" required
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('stock') border-red-500 @enderror"
                                       value="{{ old('stock', 0) }}" placeholder="0">
                                @error('stock')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label for="sku" class="block text-sm font-medium text-gray-700 mb-2">SKU</label>
                                <input type="text" name="sku" id="sku"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('sku') border-red-500 @enderror"
                                       value="{{ old('sku') }}" placeholder="SKU produk">
                                @error('sku')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Marketplace Links -->
                <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900">Link Marketplace</h3>
                    </div>
                    <div class="px-6 py-4 space-y-4">
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div>
                                <label for="shopee_url" class="block text-sm font-medium text-gray-700 mb-2">Link Shopee</label>
                                <input type="url" name="shopee_url" id="shopee_url"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('shopee_url') border-red-500 @enderror"
                                       value="{{ old('shopee_url') }}" placeholder="https://shopee.co.id/...">
                                @error('shopee_url')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="tokopedia_url" class="block text-sm font-medium text-gray-700 mb-2">Link Tokopedia</label>
                                <input type="url" name="tokopedia_url" id="tokopedia_url"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('tokopedia_url') border-red-500 @enderror"
                                       value="{{ old('tokopedia_url') }}" placeholder="https://tokopedia.com/...">
                                @error('tokopedia_url')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div>
                                <label for="bukalapak_url" class="block text-sm font-medium text-gray-700 mb-2">Link Bukalapak</label>
                                <input type="url" name="bukalapak_url" id="bukalapak_url"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('bukalapak_url') border-red-500 @enderror"
                                       value="{{ old('bukalapak_url') }}" placeholder="https://bukalapak.com/...">
                                @error('bukalapak_url')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label for="lazada_url" class="block text-sm font-medium text-gray-700 mb-2">Link Lazada</label>
                                <input type="url" name="lazada_url" id="lazada_url"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('lazada_url') border-red-500 @enderror"
                                       value="{{ old('lazada_url') }}" placeholder="https://lazada.co.id/...">
                                @error('lazada_url')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- Status -->
                <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900">Status</h3>
                    </div>
                    <div class="px-6 py-4 space-y-4">
                        <div class="flex items-center">
                            <input type="checkbox" name="is_active" id="is_active" value="1" checked
                                   class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="is_active" class="ml-2 block text-sm text-gray-900">Aktif</label>
                        </div>

                        <div class="flex items-center">
                            <input type="checkbox" name="is_featured" id="is_featured" value="1"
                                   class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="is_featured" class="ml-2 block text-sm text-gray-900">Produk Unggulan</label>
                        </div>

                        <!-- SEO Meta -->
                        <div>
                            <label for="meta_title" class="block text-sm font-medium text-gray-700 mb-2">Meta Title (SEO)</label>
                            <input type="text" name="meta_title" id="meta_title"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('meta_title') border-red-500 @enderror"
                                   value="{{ old('meta_title') }}" placeholder="SEO title">
                            @error('meta_title')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="meta_description" class="block text-sm font-medium text-gray-700 mb-2">Meta Description (SEO)</label>
                            <textarea name="meta_description" id="meta_description" rows="3"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('meta_description') border-red-500 @enderror"
                                      placeholder="SEO description">{{ old('meta_description') }}</textarea>
                            @error('meta_description')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Featured Image -->
                <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900">Gambar Utama</h3>
                    </div>
                    <div class="px-6 py-4">
                        <div class="image-upload-container">
                            <label for="featured_image" class="cursor-pointer">
                                <div id="featured_upload_area" class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-gray-400 transition-colors">
                                    <i class="fas fa-cloud-upload-alt text-gray-400 text-3xl mb-3"></i>
                                    <p class="text-sm text-gray-600">Klik untuk upload gambar</p>
                                    <p class="text-xs text-gray-500">PNG, JPG, JPEG hingga 2MB</p>
                                </div>
                            </label>
                            <input type="file" name="featured_image" id="featured_image" accept="image/*" class="hidden">
                            
                            <!-- Preview Container -->
                            <div id="featured_preview" class="mt-4 hidden">
                                <p class="text-sm font-medium text-gray-700 mb-2">Preview:</p>
                                <div class="relative">
                                    <img id="featured_preview_img" src="" alt="Preview" class="w-full h-48 object-cover rounded-lg border border-gray-300">
                                    <button type="button" onclick="removeFeaturedPreview()" class="absolute top-2 right-2 bg-red-500 hover:bg-red-600 text-white rounded-full p-1 w-6 h-6 flex items-center justify-center text-xs">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                            
                            @error('featured_image')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Gallery -->
                <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900">Galeri Gambar</h3>
                    </div>
                    <div class="px-6 py-4">
                        <div class="image-upload-container">
                            <label for="gallery" class="cursor-pointer">
                                <div id="gallery_upload_area" class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-gray-400 transition-colors">
                                    <i class="fas fa-images text-gray-400 text-3xl mb-3"></i>
                                    <p class="text-sm text-gray-600">Klik untuk upload galeri</p>
                                    <p class="text-xs text-gray-500">PNG, JPG, JPEG hingga 2MB per file</p>
                                </div>
                            </label>
                            <input type="file" name="gallery[]" id="gallery" accept="image/*" multiple class="hidden">
                            
                            <!-- Preview Container -->
                            <div id="gallery_preview" class="mt-4 hidden">
                                <p class="text-sm font-medium text-gray-700 mb-2">Preview Galeri:</p>
                                <div id="gallery_preview_container" class="grid grid-cols-2 gap-6"></div>
                                <button type="button" onclick="removeAllGalleryPreviews()" class="mt-6 text-sm text-red-600 hover:text-red-800">
                                    <i class="fas fa-trash mr-1"></i>Hapus Semua
                                </button>
                            </div>
                            
                            @error('gallery.*')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="bg-white overflow-hidden shadow-sm border border-gray-200 rounded-lg">
                    <div class="px-6 py-4">
                        <button type="submit" id="submit-btn"
                                class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out disabled:opacity-50 disabled:cursor-not-allowed">
                            <i class="fas fa-save mr-2" id="submit-icon"></i>
                            <span id="submit-text">Simpan Produk</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- JavaScript for Enhanced UX -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto generate slug from name
    const nameInput = document.getElementById('name');
    const slugInput = document.getElementById('slug');
    
    if (nameInput && slugInput) {
        nameInput.addEventListener('input', function() {
            const name = this.value;
            const slug = name.toLowerCase()
                .replace(/[^a-z0-9 -]/g, '') // remove invalid chars
                .replace(/\s+/g, '-') // collapse whitespace and replace by -
                .replace(/-+/g, '-'); // collapse dashes
            slugInput.value = slug;
        });
    }

    // Price validation
    const priceInput = document.getElementById('price');
    const discountPriceInput = document.getElementById('discount_price');
    
    if (priceInput && discountPriceInput) {
        discountPriceInput.addEventListener('input', function() {
            const price = parseFloat(priceInput.value) || 0;
            const discountPrice = parseFloat(this.value) || 0;
            
            if (discountPrice > price && price > 0) {
                alert('Harga diskon tidak boleh lebih besar dari harga normal');
                this.value = '';
            }
        });
    }

    // Featured Image Preview
    const featuredImageInput = document.getElementById('featured_image');
    const featuredPreview = document.getElementById('featured_preview');
    const featuredPreviewImg = document.getElementById('featured_preview_img');
    const featuredUploadArea = document.getElementById('featured_upload_area');
    
    featuredImageInput.addEventListener('change', function() {
        const file = this.files[0];
        if (file) {
            // Validate file size (2MB)
            if (file.size > 2 * 1024 * 1024) {
                alert('Ukuran file terlalu besar. Maksimal 2MB.');
                this.value = '';
                return;
            }
            
            // Validate file type
            if (!file.type.startsWith('image/')) {
                alert('File harus berupa gambar.');
                this.value = '';
                return;
            }
            
            const reader = new FileReader();
            reader.onload = function(e) {
                featuredPreviewImg.src = e.target.result;
                featuredPreview.classList.remove('hidden');
                featuredUploadArea.classList.add('hidden');
            };
            reader.readAsDataURL(file);
        } else {
            featuredPreview.classList.add('hidden');
            featuredUploadArea.classList.remove('hidden');
        }
    });

    // Gallery Images Preview
    const galleryInput = document.getElementById('gallery');
    const galleryPreview = document.getElementById('gallery_preview');
    const galleryPreviewContainer = document.getElementById('gallery_preview_container');
    const galleryUploadArea = document.getElementById('gallery_upload_area');
    
    galleryInput.addEventListener('change', function() {
        const files = this.files;
        
        // Clear existing previews
        galleryPreviewContainer.innerHTML = '';
        
        if (files.length > 0) {
            let validFiles = 0;
            
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                
                // Validate file size (2MB)
                if (file.size > 2 * 1024 * 1024) {
                    alert(`File ${file.name} terlalu besar. Maksimal 2MB per file.`);
                    continue;
                }
                
                // Validate file type
                if (!file.type.startsWith('image/')) {
                    alert(`File ${file.name} harus berupa gambar.`);
                    continue;
                }
                
                validFiles++;
                const reader = new FileReader();
                reader.onload = function(e) {
                    const previewDiv = document.createElement('div');
                    previewDiv.className = 'relative';
                    previewDiv.innerHTML = `
                        <img src="${e.target.result}" alt="Gallery Preview" class="w-full h-20 object-cover rounded border border-gray-300">
                        <button type="button" onclick="removeGalleryPreview(this)" class="absolute top-1 right-1 bg-red-500 hover:bg-red-600 text-white rounded-full p-1 w-5 h-5 flex items-center justify-center text-xs">
                            <i class="fas fa-times"></i>
                        </button>
                    `;
                    galleryPreviewContainer.appendChild(previewDiv);
                };
                reader.readAsDataURL(file);
            }
            
            if (validFiles > 0) {
                galleryPreview.classList.remove('hidden');
                galleryUploadArea.classList.add('hidden');
            }
        } else {
            galleryPreview.classList.add('hidden');
            galleryUploadArea.classList.remove('hidden');
        }
    });
});

// Remove featured image preview
function removeFeaturedPreview() {
    const featuredImageInput = document.getElementById('featured_image');
    const featuredPreview = document.getElementById('featured_preview');
    const featuredUploadArea = document.getElementById('featured_upload_area');
    
    featuredImageInput.value = '';
    featuredPreview.classList.add('hidden');
    featuredUploadArea.classList.remove('hidden');
}

// Remove single gallery preview
function removeGalleryPreview(button) {
    const previewDiv = button.parentElement;
    previewDiv.remove();
    
    // Check if no more previews left
    const galleryPreviewContainer = document.getElementById('gallery_preview_container');
    if (galleryPreviewContainer.children.length === 0) {
        removeAllGalleryPreviews();
    }
}

// Remove all gallery previews
function removeAllGalleryPreviews() {
    const galleryInput = document.getElementById('gallery');
    const galleryPreview = document.getElementById('gallery_preview');
    const galleryPreviewContainer = document.getElementById('gallery_preview_container');
    const galleryUploadArea = document.getElementById('gallery_upload_area');
    
    galleryInput.value = '';
    galleryPreviewContainer.innerHTML = '';
    galleryPreview.classList.add('hidden');
    galleryUploadArea.classList.remove('hidden');
}

    // Specifications management
    let specificationIndex = 1;
    
    // Add specification
    document.getElementById('add-specification').addEventListener('click', function() {
        const container = document.getElementById('specifications-container');
        const newRow = document.createElement('div');
        newRow.className = 'specification-row flex gap-2';
        newRow.innerHTML = `
            <input type="text" name="specifications[${specificationIndex}][key]" placeholder="Nama spesifikasi"
                   class="flex-1 px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            <input type="text" name="specifications[${specificationIndex}][value]" placeholder="Nilai spesifikasi"
                   class="flex-1 px-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            <button type="button" class="remove-specification px-3 py-2 text-red-600 hover:text-red-800 hover:bg-red-50 rounded-lg transition duration-150 ease-in-out">
                <i class="fas fa-trash"></i>
            </button>
        `;
        container.appendChild(newRow);
        specificationIndex++;
        
        // Add event listener to remove button
        newRow.querySelector('.remove-specification').addEventListener('click', function() {
            newRow.remove();
        });
    });
    
    // Add event listener to existing remove buttons
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-specification') || e.target.closest('.remove-specification')) {
            const button = e.target.classList.contains('remove-specification') ? e.target : e.target.closest('.remove-specification');
            const row = button.closest('.specification-row');
            if (row) {
                row.remove();
            }
        }
    });

    // Handle form submission
    const form = document.querySelector('form');
    const submitBtn = document.getElementById('submit-btn');
    const submitIcon = document.getElementById('submit-icon');
    const submitText = document.getElementById('submit-text');
    
    if (form && submitBtn) {
        form.addEventListener('submit', function() {
            // Disable button and change text
            submitBtn.disabled = true;
            submitIcon.className = 'fas fa-spinner fa-spin mr-2';
            submitText.textContent = 'Menyimpan...';
            
            // Prevent double submission
            setTimeout(() => {
                if (!form.checkValidity()) {
                    // Re-enable if form is invalid
                    submitBtn.disabled = false;
                    submitIcon.className = 'fas fa-save mr-2';
                    submitText.textContent = 'Simpan Produk';
                }
            }, 100);
        });
    }
 
</script>
@endsection
