@extends('layouts.frontend')

@section('title', 'Produk Kami')
@section('meta_description', 'Jelajahi koleksi produk berkualitas dengan harga terjangkau. Temukan produk terbaik sesuai kebutuhan Anda.')

@section('content')
    <!-- Hero Section -->
   <x-hero page-identifier="products" fallback-title="Karier di {{ setting('company_name') }}"
        fallback-subtitle="Bergabunglah dengan tim yang passionate, inovatif, dan berkomitmen untuk menciptakan masa depan yang lebih baik" />

    <!-- Products Section -->
    <section class="py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Filters -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 mb-8">
                <form method="GET" action="{{ route('products.index') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <!-- Search -->
                    <div>
                        <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Cari Produk</label>
                        <input type="text" 
                               name="search" 
                               id="search" 
                               value="{{ request('search') }}"
                               placeholder="Nama produk atau brand..."
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    </div>

                    <!-- Category -->
                    <div>
                        <label for="category" class="block text-sm font-medium text-gray-700 mb-2">Kategori</label>
                        <select name="category" 
                                id="category"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Semua Kategori</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->slug }}" {{ request('category') == $category->slug ? 'selected' : '' }}>
                                    {{ $category->name }} ({{ $category->active_products_count }})
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Price Range -->
                    <div>
                        <label for="price_range" class="block text-sm font-medium text-gray-700 mb-2">Rentang Harga</label>
                        <div class="flex space-x-2">
                            <input type="number" 
                                   name="min_price" 
                                   placeholder="Min"
                                   value="{{ request('min_price') }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <input type="number" 
                                   name="max_price" 
                                   placeholder="Max"
                                   value="{{ request('max_price') }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                    </div>

                    <!-- Sort -->
                    <div>
                        <label for="sort" class="block text-sm font-medium text-gray-700 mb-2">Urutkan</label>
                        <select name="sort" 
                                id="sort"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="latest" {{ request('sort') == 'latest' ? 'selected' : '' }}>Terbaru</option>
                            <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>Nama A-Z</option>
                            <option value="price_low" {{ request('sort') == 'price_low' ? 'selected' : '' }}>Harga Terendah</option>
                            <option value="price_high" {{ request('sort') == 'price_high' ? 'selected' : '' }}>Harga Tertinggi</option>
                            <option value="popular" {{ request('sort') == 'popular' ? 'selected' : '' }}>Terpopuler</option>
                            <option value="featured" {{ request('sort') == 'featured' ? 'selected' : '' }}>Unggulan</option>
                        </select>
                    </div>

                    <!-- Filter Button -->
                    <div class="md:col-span-4 flex justify-center">
                        <button type="submit" class="inline-flex items-center px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                            <i class="fas fa-filter mr-2"></i>
                            Filter Produk
                        </button>
                    </div>
                </form>
            </div>

            <!-- Results -->
            <div class="flex items-center justify-between mb-6">
                <div class="text-gray-600">
                    Menampilkan {{ $products->count() }} dari {{ $products->total() }} produk
                </div>
            </div>

            <!-- Products Grid -->
            @if($products->count() > 0)
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 mb-12">
                    @foreach($products as $product)
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200 hover:shadow-lg transition-shadow duration-300 group">
                            <!-- Product Image -->
                            <div class="relative overflow-hidden rounded-t-lg">
                                @if($product->featured_image)
                                    <img src="{{ $product->featured_image_url }}" 
                                         alt="{{ $product->name }}" 
                                         class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300">
                                @else
                                    <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                                        <i class="fas fa-shopping-cart text-gray-400 text-3xl"></i>
                                    </div>
                                @endif
                                
                                <!-- Badges -->
                                <div class="absolute top-2 left-2 space-y-1">
                                    @if($product->is_featured)
                                        <span class="inline-block bg-yellow-500 text-white text-xs px-2 py-1 rounded">
                                            <i class="fas fa-star"></i> Unggulan
                                        </span>
                                    @endif
                                    @if($product->has_discount)
                                        <span class="inline-block bg-red-500 text-white text-xs px-2 py-1 rounded">
                                            -{{ number_format($product->discount_percentage, 0) }}%
                                        </span>
                                    @endif
                                    @if($product->stock <= 0 && !$product->is_digital)
                                        <span class="inline-block bg-gray-500 text-white text-xs px-2 py-1 rounded">
                                            Habis
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <!-- Product Info -->
                            <div class="p-4">
                                <div class="mb-2">
                                    <span class="text-xs text-blue-600 font-medium">{{ $product->category->name }}</span>
                                </div>
                                
                                <h3 class="text-lg font-semibold text-gray-900 mb-2 line-clamp-2">
                                    <a href="{{ route('products.show', $product->slug) }}" class="hover:text-blue-600 transition-colors">
                                        {{ $product->name }}
                                    </a>
                                </h3>
                                
                                @if($product->brand)
                                    <p class="text-sm text-gray-500 mb-2">{{ $product->brand }}</p>
                                @endif
                                
                                <p class="text-sm text-gray-600 mb-3 line-clamp-2">{{ $product->short_description }}</p>
                                
                                <!-- Price -->
                                <div class="mb-4">
                                    @if($product->has_discount)
                                        <div class="flex items-center space-x-2">
                                            <span class="text-lg font-bold text-green-600">{{ $product->formatted_final_price }}</span>
                                            <span class="text-sm text-gray-500 line-through">{{ $product->formatted_price }}</span>
                                        </div>
                                    @else
                                        <span class="text-lg font-bold text-gray-900">{{ $product->formatted_final_price }}</span>
                                    @endif
                                </div>

                                <!-- Stock Info -->
                                @if(!$product->is_digital)
                                    <div class="mb-3">
                                        <span class="text-xs text-gray-500">Stok: {{ $product->stock_status }}</span>
                                    </div>
                                @endif

                                <!-- Action Buttons -->
                                <div class="space-y-3">
                                    <a href="{{ route('products.show', $product->slug) }}" 
                                       class="w-full inline-flex items-center justify-center px-4 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors font-medium">
                                        <i class="fas fa-eye mr-2"></i>
                                        Lihat Detail
                                    </a>
                                    @if(setting('contact_whatsapp'))
                                        <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', setting('contact_whatsapp')) }}?text={{ urlencode('Halo, saya tertarik dengan produk: ' . $product->name . ' - ' . route('products.show', $product->slug)) }}"
                                           target="_blank"
                                           class="w-full inline-flex items-center justify-center px-4 py-2.5 bg-green-500 text-white rounded-lg hover:bg-green-600 transition-colors font-medium">
                                            <i class="fab fa-whatsapp mr-2"></i>
                                            Tanya via WhatsApp
                                        </a>
                                    @endif
                                    <!-- Marketplace Links -->
                                    @if($product->marketplace_links)
                                        <div class="grid grid-cols-2 gap-2 mt-3">
                                            @foreach($product->marketplace_links as $marketplace => $url)
                                                <a href="{{ $url }}" 
                                                   target="_blank"
                                                   class="inline-flex items-center justify-center px-2 py-1.5 border border-gray-300 text-gray-700 rounded-md text-xs font-medium hover:bg-gray-50 hover:border-gray-400 transition-all duration-200 group">
                                                    @if($marketplace == 'shopee')
                                                        <i class="fab fa-shopify mr-1.5 text-orange-500 group-hover:text-orange-600"></i>
                                                        <span class="truncate">Shopee</span>
                                                    @elseif($marketplace == 'tokopedia')
                                                        <i class="fas fa-store mr-1.5 text-green-500 group-hover:text-green-600"></i>
                                                        <span class="truncate">Tokopedia</span>
                                                    @elseif($marketplace == 'lazada')
                                                        <i class="fas fa-shopping-cart mr-1.5 text-blue-500 group-hover:text-blue-600"></i>
                                                        <span class="truncate">Lazada</span>
                                                    @elseif($marketplace == 'blibli')
                                                        <i class="fas fa-store-alt mr-1.5 text-blue-600 group-hover:text-blue-700"></i>
                                                        <span class="truncate">Blibli</span>
                                                    @elseif($marketplace == 'bukalapak')
                                                        <i class="fas fa-shopping-bag mr-1.5 text-red-500 group-hover:text-red-600"></i>
                                                        <span class="truncate">Bukalapak</span>
                                                    @else
                                                        <i class="fas fa-external-link-alt mr-1.5 text-gray-500 group-hover:text-gray-600"></i>
                                                        <span class="truncate">{{ ucfirst($marketplace) }}</span>
                                                    @endif
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Pagination -->
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-6 mt-12 p-6 bg-white rounded-xl border border-gray-100 shadow-sm">
                    <!-- Pagination Info -->
                    <div class="text-sm text-gray-600 order-2 sm:order-1">
                        Menampilkan 
                        <span class="font-semibold text-gray-900">{{ $products->firstItem() ?? 0 }}</span>
                        -
                        <span class="font-semibold text-gray-900">{{ $products->lastItem() ?? 0 }}</span>
                        dari 
                        <span class="font-semibold text-gray-900">{{ $products->total() }}</span>
                        produk
                    </div>
                    
                    <!-- Pagination Links -->
                    <div class="order-1 sm:order-2">
                        {{ $products->appends(request()->query())->links('pagination.custom') }}
                    </div>
                </div>
            @else
                <!-- No Products -->
                <div class="text-center py-16">
                    <i class="fas fa-search text-gray-400 text-6xl mb-4"></i>
                    <h3 class="text-xl font-semibold text-gray-900 mb-2">Tidak ada produk ditemukan</h3>
                    <p class="text-gray-600 mb-6">Coba ubah filter pencarian atau kata kunci yang digunakan.</p>
                    <a href="{{ route('products.index') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i>
                        Lihat Semua Produk
                    </a>
                </div>
            @endif
        </div>
    </section>

    <!-- Categories Section -->
    @if($categories->count() > 0)
        <section class="py-16 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <h2 class="text-3xl font-bold text-gray-900 mb-4">Jelajahi Kategori</h2>
                    <p class="text-lg text-gray-600">Temukan produk berdasarkan kategori yang Anda butuhkan</p>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
                    @foreach($categories as $category)
                        <a href="{{ route('products.category', $category->slug) }}" class="group">
                            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 text-center hover:shadow-lg transition-shadow duration-300">
                                @if($category->image)
                                    <img src="{{ $category->image_url }}" 
                                         alt="{{ $category->name }}" 
                                         class="w-16 h-16 mx-auto mb-4 rounded-full object-cover">
                                @else
                                    <div class="w-16 h-16 mx-auto mb-4 bg-blue-100 rounded-full flex items-center justify-center">
                                        <i class="fas fa-tags text-blue-600 text-xl"></i>
                                    </div>
                                @endif
                                <h3 class="text-lg font-semibold text-gray-900 group-hover:text-blue-600 transition-colors">{{ $category->name }}</h3>
                                <p class="text-sm text-gray-500 mt-1">{{ $category->active_products_count }} produk</p>
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
@endsection

@push('styles')
<style>
.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
</style>
@endpush
