@extends('layouts.frontend')

@section('title', 'Pencarian Produk: ' . request('q'))
@section('meta_description', 'Hasil pencarian produk untuk kata kunci: ' . request('q'))

@section('content')
<!-- Hero Section -->
<section class="hero-section bg-primary text-white py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 mb-3">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}" class="text-white-50">Beranda</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('products.index') }}" class="text-white-50">Produk</a></li>
                        <li class="breadcrumb-item active text-white" aria-current="page">Pencarian</li>
                    </ol>
                </nav>
                <h1 class="display-4 mb-3">Hasil Pencarian</h1>
                @if(request('q'))
                    <p class="lead">Kata kunci: <strong>"{{ request('q') }}"</strong></p>
                @endif
                @if(request('category'))
                    <p class="lead">Kategori: <strong>{{ $selectedCategory?->name ?? 'Semua Kategori' }}</strong></p>
                @endif
                <div class="mt-4">
                    <span class="badge badge-light badge-lg">{{ $products->total() }} Produk Ditemukan</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Search & Filter Section -->
<section class="search-filter-section bg-light py-4">
    <div class="container">
        <form method="GET" action="{{ route('products.search') }}">
            <div class="row">
                <div class="col-md-5">
                    <div class="input-group">
                        <input type="text" 
                               name="q" 
                               class="form-control form-control-lg" 
                               placeholder="Cari produk..." 
                               value="{{ request('q') }}">
                        <div class="input-group-append">
                            <button class="btn btn-primary" type="submit">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <select name="category" class="form-control form-control-lg">
                        <option value="">Semua Kategori</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->slug }}" {{ request('category') == $category->slug ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="sort" class="form-control form-control-lg">
                        <option value="relevance" {{ request('sort') == 'relevance' ? 'selected' : '' }}>Relevansi</option>
                        <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>Nama A-Z</option>
                        <option value="name_desc" {{ request('sort') == 'name_desc' ? 'selected' : '' }}>Nama Z-A</option>
                        <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>Harga Terendah</option>
                        <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>Harga Tertinggi</option>
                        <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>Terbaru</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-success btn-lg btn-block">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </div>
        </form>
    </div>
</section>

<!-- Results Section -->
<section class="results-section py-5">
    <div class="container">
        @if(request('q') || request('category'))
        <!-- Search Info -->
        <div class="row mb-4">
            <div class="col-md-6">
                <h4>Hasil Pencarian</h4>
                @if($products->total() > 0)
                    <p class="text-muted">Menampilkan {{ $products->firstItem() }}-{{ $products->lastItem() }} dari {{ $products->total() }} produk</p>
                @endif
            </div>
            <div class="col-md-6 text-right">
                @if(request('q') || request('category'))
                    <a href="{{ route('products.search') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-times"></i> Hapus Filter
                    </a>
                @endif
            </div>
        </div>

        @if($products->count() > 0)
        <!-- Products Grid -->
        <div class="row">
            @foreach($products as $product)
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card product-card h-100 shadow-sm">
                    <div class="position-relative">
                        @if($product->featured_image)
                            <img src="{{ Storage::url($product->featured_image) }}" 
                                 class="card-img-top" 
                                 alt="{{ $product->name }}"
                                 style="height: 250px; object-fit: cover;">
                        @else
                            <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 250px;">
                                <i class="fas fa-image fa-3x text-muted"></i>
                            </div>
                        @endif
                        
                        @if($product->discount_percentage > 0)
                            <span class="badge badge-danger position-absolute" style="top: 10px; right: 10px;">
                                -{{ $product->discount_percentage }}%
                            </span>
                        @endif

                        @if($product->is_featured)
                            <span class="badge badge-warning position-absolute" style="top: 10px; left: 10px;">
                                <i class="fas fa-star"></i> Unggulan
                            </span>
                        @endif

                        @if($product->stock <= 0)
                            <div class="position-absolute w-100 h-100 d-flex align-items-center justify-content-center" style="background: rgba(0,0,0,0.7); top: 0; left: 0;">
                                <span class="badge badge-danger badge-lg">Stok Habis</span>
                            </div>
                        @endif
                    </div>
                    
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title">
                            <a href="{{ route('products.show', $product->slug) }}" class="text-dark text-decoration-none">
                                {!! request('q') ? str_ireplace(request('q'), '<mark>' . request('q') . '</mark>', $product->name) : $product->name !!}
                            </a>
                        </h5>
                        
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            @if($product->brand)
                                <span class="badge badge-secondary">{{ $product->brand }}</span>
                            @endif
                            <small class="text-muted">
                                <i class="fas fa-folder"></i> {{ $product->category->name }}
                            </small>
                        </div>

                        @if($product->short_description)
                            <p class="card-text text-muted small">
                                {!! request('q') ? str_ireplace(request('q'), '<mark>' . request('q') . '</mark>', Str::limit($product->short_description, 100)) : Str::limit($product->short_description, 100) !!}
                            </p>
                        @endif
                        
                        <div class="mt-auto">
                            <div class="price-section mb-3">
                                @if($product->discount_price)
                                    <span class="h5 text-danger mb-0">{{ $product->formatted_discount_price }}</span>
                                    <br>
                                    <small class="text-muted"><del>{{ $product->formatted_price }}</del></small>
                                @else
                                    <span class="h5 text-primary mb-0">{{ $product->formatted_price }}</span>
                                @endif
                            </div>
                            
                            <div class="d-flex justify-content-between align-items-center">
                                <a href="{{ route('products.show', $product->slug) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-eye"></i> Detail
                                </a>
                                
                                    @if(setting('contact_whatsapp'))
                                        <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', setting('contact_whatsapp')) }}?text={{ urlencode('Halo, saya tertarik dengan produk: ' . $product->name . ' - ' . route('products.show', $product->slug)) }}"
                                           target="_blank"
                                           class="w-full inline-flex items-center justify-center px-4 py-2.5 bg-green-500 text-white rounded-lg hover:bg-green-600 transition-colors font-medium">
                                            <i class="fab fa-whatsapp mr-2"></i>
                                            Tanya via WhatsApp
                                        </a>
                                    @endif
                                @if($product->stock > 0)
                                    <div class="dropdown">
                                        <button class="btn btn-success btn-sm dropdown-toggle" type="button" data-toggle="dropdown">
                                            <i class="fas fa-shopping-cart"></i> Beli
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            @if($product->shopee_url)
                                                <a class="dropdown-item" href="{{ $product->shopee_url }}" target="_blank">
                                                    <i class="fab fa-shopify text-danger"></i> Shopee
                                                </a>
                                            @endif
                                            @if($product->tokopedia_url)
                                                <a class="dropdown-item" href="{{ $product->tokopedia_url }}" target="_blank">
                                                    <i class="fas fa-shopping-cart text-success"></i> Tokopedia
                                                </a>
                                            @endif
                                            @if($product->bukalapak_url)
                                                <a class="dropdown-item" href="{{ $product->bukalapak_url }}" target="_blank">
                                                    <i class="fas fa-shopping-bag text-pink"></i> Bukalapak
                                                </a>
                                            @endif
                                            @if($product->lazada_url)
                                                <a class="dropdown-item" href="{{ $product->lazada_url }}" target="_blank">
                                                    <i class="fas fa-store text-primary"></i> Lazada
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                @else
                                    <span class="badge badge-secondary">Stok Habis</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <!-- Pagination -->
        @if($products->hasPages())
        <div class="row">
            <div class="col-12 d-flex justify-content-center">
                {{ $products->appends(request()->query())->links() }}
            </div>
        </div>
        @endif

        @else
        <!-- No Results -->
        <div class="row">
            <div class="col-12">
                <div class="text-center py-5">
                    <i class="fas fa-search fa-4x text-muted mb-4"></i>
                    <h4>Tidak Ada Hasil</h4>
                    @if(request('q'))
                        <p class="text-muted">Maaf, tidak ada produk yang ditemukan untuk kata kunci <strong>"{{ request('q') }}"</strong></p>
                    @else
                        <p class="text-muted">Silakan masukkan kata kunci pencarian</p>
                    @endif
                    
                    <div class="mt-4">
                        <h6>Saran:</h6>
                        <ul class="list-unstyled text-muted">
                            <li>• Periksa ejaan kata kunci</li>
                            <li>• Gunakan kata kunci yang lebih umum</li>
                            <li>• Coba kategori yang berbeda</li>
                        </ul>
                    </div>
                    
                    <a href="{{ route('products.index') }}" class="btn btn-primary mt-3">
                        <i class="fas fa-arrow-left"></i> Lihat Semua Produk
                    </a>
                </div>
            </div>
        </div>
        @endif

        @else
        <!-- Initial Search Page -->
        <div class="row">
            <div class="col-12">
                <div class="text-center py-5">
                    <i class="fas fa-search fa-4x text-primary mb-4"></i>
                    <h4>Cari Produk</h4>
                    <p class="text-muted">Gunakan form di atas untuk mencari produk yang Anda inginkan</p>
                    
                    <!-- Popular Search Terms -->
                    @if($popularProducts->count() > 0)
                    <div class="mt-5">
                        <h6>Produk Populer:</h6>
                        <div class="row justify-content-center">
                            @foreach($popularProducts as $popular)
                            <div class="col-lg-3 col-md-4 col-sm-6 mb-3">
                                <a href="{{ route('products.show', $popular->slug) }}" class="btn btn-outline-primary btn-sm btn-block">
                                    {{ $popular->name }}
                                </a>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                    
                    <a href="{{ route('products.index') }}" class="btn btn-primary mt-3">
                        <i class="fas fa-th"></i> Lihat Semua Produk
                    </a>
                </div>
            </div>
        </div>
        @endif
    </div>
</section>

<!-- Categories Section -->
@if($categories->count() > 0)
<section class="categories-section bg-light py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h3>Jelajahi Berdasarkan Kategori</h3>
            <p class="text-muted">Temukan produk berdasarkan kategori yang Anda minati</p>
        </div>
        
        <div class="row">
            @foreach($categories->take(8) as $category)
            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                <div class="card category-card h-100 shadow-sm">
                    <a href="{{ route('products.category', $category->slug) }}" class="text-decoration-none">
                        @if($category->image)
                            <img src="{{ Storage::url($category->image) }}" 
                                 class="card-img-top" 
                                 alt="{{ $category->name }}"
                                 style="height: 150px; object-fit: cover;">
                        @else
                            <div class="card-img-top bg-primary d-flex align-items-center justify-content-center" style="height: 150px;">
                                <i class="fas fa-folder fa-2x text-white"></i>
                            </div>
                        @endif
                        
                        <div class="card-body text-center">
                            <h6 class="card-title text-dark">{{ $category->name }}</h6>
                            <small class="text-muted">{{ $category->products_count }} produk</small>
                        </div>
                    </a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif
@endsection

@section('styles')
<style>
.product-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.product-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1) !important;
}

.category-card {
    transition: transform 0.3s ease;
}

.category-card:hover {
    transform: scale(1.05);
}

.text-pink {
    color: #e91e63 !important;
}

.hero-section {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.badge-lg {
    padding: 0.5rem 1rem;
    font-size: 0.9rem;
}

mark {
    background-color: #fff3cd;
    padding: 0.1em 0.2em;
    border-radius: 0.2em;
}

.search-filter-section {
    border-bottom: 1px solid #dee2e6;
}
</style>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Auto submit form when category or sort changes
    $('select[name="category"], select[name="sort"]').on('change', function() {
        $(this).closest('form').submit();
    });
    
    // Focus on search input if no results
    @if(request('q') && $products->count() == 0)
        $('input[name="q"]').focus().select();
    @endif
});
</script>
@endsection
