@extends('layouts.frontend')

@section('title', $product->meta_title ?: $product->name)
@section('meta_description', $product->meta_description ?: $product->short_description)

@section('content')
    <!-- Breadcrumbs -->
    <nav class="bg-gray-50 py-4">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <ol class="flex items-center space-x-2 text-sm">
                <li><a href="{{ route('home') }}" class="text-blue-600 hover:text-blue-800">Beranda</a></li>
                <li><i class="fas fa-chevron-right text-gray-400"></i></li>
                <li><a href="{{ route('products.index') }}" class="text-blue-600 hover:text-blue-800">Produk</a></li>
                <li><i class="fas fa-chevron-right text-gray-400"></i></li>
                <li><a href="{{ route('products.category', $product->category->slug) }}" class="text-blue-600 hover:text-blue-800">{{ $product->category->name }}</a></li>
                <li><i class="fas fa-chevron-right text-gray-400"></i></li>
                <li class="text-gray-900">{{ $product->name }}</li>
            </ol>
        </div>
    </nav>

    <!-- Product Detail -->
    <section class="py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
                <!-- Product Images -->
                <div class="space-y-4">
                    <!-- Main Image -->
                    <div class="aspect-w-1 aspect-h-1">
                        @if($product->featured_image)
                            <img id="main-image" 
                                 src="{{ $product->featured_image_url }}" 
                                 alt="{{ $product->name }}" 
                                 class="w-full h-96 object-cover rounded-lg border border-gray-200">
                        @else
                            <div class="w-full h-96 bg-gray-200 rounded-lg flex items-center justify-center">
                                <i class="fas fa-shopping-cart text-gray-400 text-6xl"></i>
                            </div>
                        @endif
                    </div>

                    <!-- Thumbnail Images -->
                    @if($product->gallery && count($product->gallery_urls) > 0)
                        <div class="flex space-x-2 overflow-x-auto">
                            @if($product->featured_image)
                                <img src="{{ $product->featured_image_url }}" 
                                     alt="{{ $product->name }}" 
                                     class="thumbnail w-20 h-20 object-cover rounded border border-gray-200 cursor-pointer opacity-100"
                                     onclick="changeMainImage('{{ $product->featured_image_url }}')">
                            @endif
                            @foreach($product->gallery_urls as $image)
                                <img src="{{ $image }}" 
                                     alt="{{ $product->name }}" 
                                     class="thumbnail w-20 h-20 object-cover rounded border border-gray-200 cursor-pointer opacity-60 hover:opacity-100"
                                     onclick="changeMainImage('{{ $image }}')">
                            @endforeach
                        </div>
                    @endif
                </div>

                <!-- Product Info -->
                <div class="space-y-6">
                    <!-- Basic Info -->
                    <div>
                        <div class="mb-2">
                            <span class="inline-block bg-blue-100 text-blue-800 text-sm px-2 py-1 rounded">
                                {{ $product->category->name }}
                            </span>
                        </div>
                        
                        <h1 class="text-3xl font-bold text-gray-900 mb-2">{{ $product->name }}</h1>
                        
                        @if($product->brand)
                            <p class="text-lg text-gray-600 mb-4">Brand: {{ $product->brand }}</p>
                        @endif

                        <div class="flex items-center space-x-4 mb-4">
                            <span class="text-sm text-gray-500">SKU: {{ $product->sku }}</span>
                            <span class="text-sm text-gray-500">{{ $product->views }} views</span>
                        </div>
                    </div>

                    <!-- Price -->
                    <div class="border-t border-b border-gray-200 py-6">
                        @if($product->has_discount)
                            <div class="flex items-center space-x-4 mb-2">
                                <span class="text-3xl font-bold text-green-600">{{ $product->formatted_final_price }}</span>
                                <span class="text-xl text-gray-500 line-through">{{ $product->formatted_price }}</span>
                                <span class="bg-red-100 text-red-800 text-sm px-2 py-1 rounded">
                                    -{{ number_format($product->discount_percentage, 0) }}%
                                </span>
                            </div>
                            <p class="text-sm text-green-600">Hemat {{ $product->formatted_discount_amount }}</p>
                        @else
                            <span class="text-3xl font-bold text-gray-900">{{ $product->formatted_final_price }}</span>
                        @endif
                    </div>

                    <!-- Stock Info -->
                    <div>
                        @if($product->is_digital)
                            <div class="flex items-center text-blue-600">
                                <i class="fas fa-download mr-2"></i>
                                <span>Produk Digital</span>
                            </div>
                        @else
                            <div class="flex items-center space-x-2">
                                <span class="text-gray-700">Stok:</span>
                                @if($product->stock > 0)
                                    <span class="text-green-600 font-medium">{{ $product->stock }} tersedia</span>
                                    @if($product->stock <= 10)
                                        <span class="text-yellow-600 text-sm">(Tinggal sedikit!)</span>
                                    @endif
                                @else
                                    <span class="text-red-600 font-medium">Habis</span>
                                @endif
                            </div>
                        @endif
                    </div>

                    <!-- Short Description -->
                    @if($product->short_description)
                        <div>
                            <p class="text-gray-700 leading-relaxed">{{ $product->short_description }}</p>
                        </div>
                    @endif
                    
                    @if(setting('contact_whatsapp'))
                        <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', setting('contact_whatsapp')) }}?text={{ urlencode('Halo, saya tertarik dengan produk: ' . $product->name . ' - ' . route('products.show', $product->slug)) }}"
                            target="_blank"
                            class="w-full inline-flex items-center justify-center px-4 py-2.5 bg-green-500 text-white rounded-lg hover:bg-green-600 transition-colors font-medium">
                            <i class="fab fa-whatsapp mr-2"></i>
                            Tanya via WhatsApp
                        </a>
                    @endif

                    <!-- Marketplace Links -->
                    @if($product->marketplace_links)
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-3">Beli di Marketplace</h3>
                            <div class="grid grid-cols-2 gap-3">
                                @foreach($product->marketplace_links as $marketplace => $url)
                                    <a href="{{ $url }}" 
                                       target="_blank"
                                       class="inline-flex items-center justify-center px-4 py-3 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-colors">
                                        @if($marketplace == 'shopee')
                                            <i class="fas fa-shopping-bag mr-2 text-orange-500"></i>
                                            <span>Beli di Shopee</span>
                                        @elseif($marketplace == 'tokopedia')
                                            <i class="fas fa-store mr-2 text-green-500"></i>
                                            <span>Beli di Tokopedia</span>
                                        @elseif($marketplace == 'lazada')
                                            <i class="fas fa-shopping-cart mr-2 text-blue-500"></i>
                                            <span>Beli di Lazada</span>
                                        @elseif($marketplace == 'bukalapak')
                                            <i class="fas fa-shopping-bag mr-2 text-red-500"></i>
                                            <span>Beli di Bukalapak</span>
                                        @elseif($marketplace == 'blibli')
                                            <i class="fas fa-store mr-2 text-blue-600"></i>
                                            <span>Beli di Blibli</span>
                                        @else
                                            <span>Beli di {{ ucfirst($marketplace) }}</span>
                                        @endif
                                        <i class="fas fa-external-link-alt ml-2 text-sm"></i>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <!-- Tags -->
                    @if($product->tags && count($product->tags) > 0)
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 mb-2">Tags:</h3>
                            <div class="flex flex-wrap gap-2">
                                @foreach($product->tags as $tag)
                                    <span class="inline-block bg-gray-100 text-gray-700 text-sm px-2 py-1 rounded">{{ $tag }}</span>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Product Details Tabs -->
            <div class="mt-16">
                <div class="border-b border-gray-200">
                    <nav class="flex space-x-8">
                        <button class="tab-button py-2 px-1 border-b-2 border-blue-500 text-blue-600 font-medium" 
                                data-tab="description">
                            Deskripsi
                        </button>
                        @if($product->specifications && count($product->specifications) > 0)
                            <button class="tab-button py-2 px-1 border-b-2 border-transparent text-gray-500 hover:text-gray-700" 
                                    data-tab="specifications">
                                Spesifikasi
                            </button>
                        @endif
                        @if($product->dimensions || $product->weight)
                            <button class="tab-button py-2 px-1 border-b-2 border-transparent text-gray-500 hover:text-gray-700" 
                                    data-tab="shipping">
                                Info Pengiriman
                            </button>
                        @endif
                    </nav>
                </div>

                <div class="py-8">
                    <!-- Description Tab -->
                    <div id="description" class="tab-content">
                        <div class="prose max-w-none">
                            {!! nl2br(e($product->description)) !!}
                        </div>
                    </div>

                    <!-- Specifications Tab -->
                    @if($product->specifications && count($product->specifications) > 0)
                        <div id="specifications" class="tab-content hidden">
                            <div class="bg-gray-50 rounded-lg p-6">
                                <table class="w-full">
                                    @foreach($product->specifications as $spec)
                                        <tr class="border-b border-gray-200">
                                            <td class="py-3 pr-6 font-medium text-gray-900 w-1/3">{{ $spec['key'] }}</td>
                                            <td class="py-3 text-gray-700">{{ $spec['value'] }}</td>
                                        </tr>
                                    @endforeach
                                </table>
                            </div>
                        </div>
                    @endif

                    <!-- Shipping Tab -->
                    @if($product->dimensions || $product->weight)
                        <div id="shipping" class="tab-content hidden">
                            <div class="bg-gray-50 rounded-lg p-6">
                                <table class="w-full">
                                    @if($product->weight)
                                        <tr class="border-b border-gray-200">
                                            <td class="py-3 pr-6 font-medium text-gray-900 w-1/3">Berat</td>
                                            <td class="py-3 text-gray-700">{{ $product->weight }} gram</td>
                                        </tr>
                                    @endif
                                    @if($product->dimensions)
                                        <tr class="border-b border-gray-200">
                                            <td class="py-3 pr-6 font-medium text-gray-900 w-1/3">Dimensi</td>
                                            <td class="py-3 text-gray-700">
                                                {{ $product->dimensions['length'] ?? '-' }} x 
                                                {{ $product->dimensions['width'] ?? '-' }} x 
                                                {{ $product->dimensions['height'] ?? '-' }} cm
                                            </td>
                                        </tr>
                                    @endif
                                    @if($product->min_order > 1)
                                        <tr class="border-b border-gray-200">
                                            <td class="py-3 pr-6 font-medium text-gray-900 w-1/3">Minimal Order</td>
                                            <td class="py-3 text-gray-700">{{ $product->min_order }} pcs</td>
                                        </tr>
                                    @endif
                                </table>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </section>

    <!-- Related Products -->
    @if($relatedProducts->count() > 0)
        <section class="py-16 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <h2 class="text-3xl font-bold text-gray-900 mb-4">Produk Terkait</h2>
                    <p class="text-lg text-gray-600">Produk lain yang mungkin Anda sukai</p>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                    @foreach($relatedProducts as $relatedProduct)
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200 hover:shadow-lg transition-shadow duration-300 group">
                            <!-- Product Image -->
                            <div class="relative overflow-hidden rounded-t-lg">
                                @if($relatedProduct->featured_image)
                                    <img src="{{ $relatedProduct->featured_image_url }}" 
                                         alt="{{ $relatedProduct->name }}" 
                                         class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300">
                                @else
                                    <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                                        <i class="fas fa-shopping-cart text-gray-400 text-3xl"></i>
                                    </div>
                                @endif
                                
                                @if($relatedProduct->has_discount)
                                    <span class="absolute top-2 left-2 bg-red-500 text-white text-xs px-2 py-1 rounded">
                                        -{{ number_format($relatedProduct->discount_percentage, 0) }}%
                                    </span>
                                @endif
                            </div>

                            <!-- Product Info -->
                            <div class="p-4">
                                <h3 class="text-lg font-semibold text-gray-900 mb-2 line-clamp-2">
                                    <a href="{{ route('products.show', $relatedProduct->slug) }}" class="hover:text-blue-600 transition-colors">
                                        {{ $relatedProduct->name }}
                                    </a>
                                </h3>
                                
                                <!-- Price -->
                                <div class="mb-3">
                                    @if($relatedProduct->has_discount)
                                        <div class="flex items-center space-x-2">
                                            <span class="text-lg font-bold text-green-600">{{ $relatedProduct->formatted_final_price }}</span>
                                            <span class="text-sm text-gray-500 line-through">{{ $relatedProduct->formatted_price }}</span>
                                        </div>
                                    @else
                                        <span class="text-lg font-bold text-gray-900">{{ $relatedProduct->formatted_final_price }}</span>
                                    @endif
                                </div>

                                <a href="{{ route('products.show', $relatedProduct->slug) }}" 
                                   class="w-full inline-flex items-center justify-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                                    Lihat Detail
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
@endsection

@push('scripts')
<script>
// Tab functionality
document.addEventListener('DOMContentLoaded', function() {
    const tabButtons = document.querySelectorAll('.tab-button');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');

            // Remove active classes from all buttons and contents
            tabButtons.forEach(btn => {
                btn.classList.remove('border-blue-500', 'text-blue-600');
                btn.classList.add('border-transparent', 'text-gray-500');
            });
            
            tabContents.forEach(content => {
                content.classList.add('hidden');
            });

            // Add active classes to clicked button and show target content
            this.classList.remove('border-transparent', 'text-gray-500');
            this.classList.add('border-blue-500', 'text-blue-600');
            
            document.getElementById(targetTab).classList.remove('hidden');
        });
    });
});

// Image gallery functionality
function changeMainImage(src) {
    document.getElementById('main-image').src = src;
    
    // Update thumbnail opacity
    document.querySelectorAll('.thumbnail').forEach(thumb => {
        thumb.classList.remove('opacity-100');
        thumb.classList.add('opacity-60');
    });
    
    // Highlight selected thumbnail
    event.target.classList.remove('opacity-60');
    event.target.classList.add('opacity-100');
}
</script>
@endpush

@push('styles')
<style>
.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.prose {
    color: #374151;
    line-height: 1.75;
}

.prose p {
    margin-bottom: 1.25em;
}
</style>
@endpush
