<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
      @stack('seo')
    
    <!-- Default SEO if not overridden -->
    @if(!isset($pageIdentifier))
        <title>@yield('title', setting('site_name', 'Company Profile'))</title>
        <meta name="description" content="@yield('meta_description', setting('meta_description', 'Professional company profile website'))">
        
        <!-- SEO -->
        <meta property="og:title" content="@yield('title', setting('site_name', 'Company Profile'))">
        <meta property="og:description" content="@yield('meta_description', setting('meta_description', 'Professional company profile website'))">
        <meta property="og:type" content="website">
        <meta property="og:url" content="{{ url()->current() }}">
        <meta property="og:image" content="@yield('og_image', asset('images/og-image.jpg'))">
    @endif
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('storage/'.setting('favicon', '/favicon.ico')) }}">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700" rel="stylesheet" />
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

      <!-- Styles -->
    {{-- @vite(['resources/css/app.css', 'resources/js/app.js']) --}}
    
    <!-- Custom Styles for Enhanced UI -->
    <style>
        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }
        
        /* Custom animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes fadeInScale {
            from {
                opacity: 0;
                transform: scale(0.95);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
        
        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        @keyframes float {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-10px);
            }
        }
        
        /* Animation classes */
        .animate-fade-in-up {
            animation: fadeInUp 0.6s ease-out;
        }
        
        .animate-fade-in-scale {
            animation: fadeInScale 0.6s ease-out;
        }
        
        .animate-slide-in-left {
            animation: slideInLeft 0.6s ease-out;
        }
        
        .animate-slide-in-right {
            animation: slideInRight 0.6s ease-out;
        }
        
        .animate-float {
            animation: float 3s ease-in-out infinite;
        }
        
        /* Gradient text */
        .gradient-text {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        /* Glass effect */
        .glass-effect {
            background: rgba(255, 255, 255, 0.25);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.18);
        }
        
        /* Hover scale effect */
        .hover-scale {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .hover-scale:hover {
            transform: translateY(-5px) scale(1.02);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        }
        
        /* Button ripple effect */
        .btn-ripple {
            position: relative;
            overflow: hidden;
        }
        
        .btn-ripple::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            transition: width 0.6s, height 0.6s;
            transform: translate(-50%, -50%);
        }
        
        .btn-ripple:hover::before {
            width: 300px;
            height: 300px;
        }
        
        /* Smooth transitions */
        * {
            transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, backdrop-filter;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 150ms;
        }
        
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, #5a67d8 0%, #6b46c1 100%);
        }
        
        /* Loading states */
        .loading-skeleton {
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: loading 1.5s infinite;
        }
        
        @keyframes loading {
            0% {
                background-position: 200% 0;
            }
            100% {
                background-position: -200% 0;
            }
        }
        
        /* Image lazy loading */
        img {
            transition: opacity 0.3s ease;
        }
        
        img[loading="lazy"] {
            opacity: 0;
        }
        
        img[loading="lazy"].loaded {
            opacity: 1;
        }
    </style>
    
    @stack('styles')
</head>
<body class="bg-white text-gray-900 antialiased">
    <!-- Header -->
    <header class="fixed top-0 w-full bg-white/95 backdrop-blur-sm border-b border-gray-100 z-50">
        <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo -->
                <div class="flex-shrink-0">
                    <a href="{{ route('home') }}" class="flex items-center">
                        @if(setting('logo'))
                            <img src="{{ asset('storage/'.setting('logo')) }}" alt="{{ setting('site_name') }}" class="h-16 w-auto">
                        @else
                            <span class="text-2xl font-bold text-blue-600">{{ setting('site_name', 'Company') }}</span>
                        @endif
                    </a>
                </div>
                
                <!-- Desktop Navigation -->
                <div class="hidden md:flex space-x-1">
                    @if(isset($globalMenuItems))
                        @foreach($globalMenuItems as $menu)
                            @if($menu->is_visible && $menu->visibleChildren->count() > 0)
                                <!-- Menu with Dropdown -->
                                <div class="relative group">
                                    <a href="{{ $menu->url }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 flex items-center rounded-lg hover:bg-blue-50 {{ $menu->isActive() || $menu->hasActiveChildren() ? 'text-blue-600 bg-blue-50' : '' }}">
                                        @if($menu->icon && $menu->show_icon)
                                            <i class="{{ $menu->icon }} mr-2"></i>
                                        @endif
                                        {{ $menu->title }}
                                        <i class="fas fa-chevron-down ml-1 text-xs transition-transform group-hover:rotate-180"></i>
                                        @if($menu->isActive() || $menu->hasActiveChildren())
                                            <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                                        @endif
                                    </a>
                                    <!-- Dropdown Menu -->
                                    <div class="absolute left-0 mt-2 w-52 bg-white rounded-lg shadow-xl border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50">
                                        <div class="py-2">
                                            @foreach($menu->visibleChildren as $child)
                                                <a href="{{ $child->url }}" class="flex items-center px-4 py-2.5 text-sm text-gray-700 hover:bg-blue-50 hover:text-blue-600 transition-colors {{ $child->isActive() ? 'bg-blue-50 text-blue-600 border-r-2 border-blue-600' : '' }}">
                                                    @if($child->icon && $child->show_icon)
                                                        <i class="{{ $child->icon }} mr-3 w-4"></i>
                                                    @endif
                                                    {{ $child->title }}
                                                    @if($child->isActive())
                                                        <i class="fas fa-check ml-auto text-blue-600 text-xs"></i>
                                                    @endif
                                                </a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @elseif($menu->is_visible)
                                <!-- Simple Menu -->
                                <a href="{{ $menu->url }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ $menu->isActive() ? 'text-blue-600 bg-blue-50' : '' }}">
                                    @if($menu->icon && $menu->show_icon)
                                        <i class="{{ $menu->icon }} mr-2"></i>
                                    @endif
                                    {{ $menu->title }}
                                    @if($menu->isActive())
                                        <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                                    @endif
                                </a>
                            @endif
                        @endforeach
                    @else
                        <!-- Fallback Static Menu -->
                        <a href="{{ route('home') }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ request()->routeIs('home') ? 'text-blue-600 bg-blue-50' : '' }}">
                            <i class="fas fa-home mr-2"></i>
                            Beranda
                            @if(request()->routeIs('home'))
                                <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                            @endif
                        </a>
                        <a href="{{ route('about') }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ request()->routeIs('about') || request()->is('tentang-kami*') ? 'text-blue-600 bg-blue-50' : '' }}">
                            <i class="fas fa-info-circle mr-2"></i>
                            Tentang Kami
                            @if(request()->routeIs('about') || request()->is('tentang-kami*'))
                                <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                            @endif
                        </a>
                        <a href="{{ route('services.index') }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ request()->routeIs('services*') || request()->is('layanan*') ? 'text-blue-600 bg-blue-50' : '' }}">
                            <i class="fas fa-cogs mr-2"></i>
                            Layanan
                            @if(request()->routeIs('services*') || request()->is('layanan*'))
                                <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                            @endif
                        </a>
                        <a href="{{ route('products.index') }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ request()->routeIs('products*') || request()->is('produk*') ? 'text-blue-600 bg-blue-50' : '' }}">
                            <i class="fas fa-shopping-cart mr-2"></i>
                            Produk
                            @if(request()->routeIs('products*') || request()->is('produk*'))
                                <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                            @endif
                        </a>
                        <a href="{{ route('projects.index') }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ request()->routeIs('projects*') || request()->is('portofolio*') ? 'text-blue-600 bg-blue-50' : '' }}">
                            <i class="fas fa-briefcase mr-2"></i>
                            Portofolio
                            @if(request()->routeIs('projects*') || request()->is('portofolio*'))
                                <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                            @endif
                        </a>
                        <a href="{{ route('articles.index') }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ request()->routeIs('articles*') || request()->is('artikel*') ? 'text-blue-600 bg-blue-50' : '' }}">
                            <i class="fas fa-newspaper mr-2"></i>
                            Artikel
                            @if(request()->routeIs('articles*') || request()->is('artikel*'))
                                <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                            @endif
                        </a>
                        <a href="{{ route('careers.index') }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ request()->routeIs('careers*') || request()->is('karier*') ? 'text-blue-600 bg-blue-50' : '' }}">
                            <i class="fas fa-user-tie mr-2"></i>
                            Karier
                            @if(request()->routeIs('careers*') || request()->is('karier*'))
                                <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                            @endif
                        </a>
                        <a href="{{ route('contact') }}" class="relative text-gray-700 hover:text-blue-600 px-4 py-2 text-sm font-medium transition-all duration-200 rounded-lg hover:bg-blue-50 {{ request()->routeIs('contact') || request()->is('kontak*') ? 'text-blue-600 bg-blue-50' : '' }}">
                            <i class="fas fa-envelope mr-2"></i>
                            Kontak
                            @if(request()->routeIs('contact') || request()->is('kontak*'))
                                <span class="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-1 h-1 bg-blue-600 rounded-full"></span>
                            @endif
                        </a>
                    @endif
                </div>
                
                <!-- Mobile menu button -->
                <div class="md:hidden">
                    <button type="button" class="mobile-menu-button text-gray-700 hover:text-blue-600 focus:outline-none focus:text-blue-600">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
            </div>
            
            <!-- Mobile Navigation -->
            <div class="mobile-menu hidden md:hidden">
                <div class="px-2 pt-2 pb-3 space-y-1 border-t border-gray-100 bg-white/95 backdrop-blur-sm">
                    @if(isset($globalMenuItems))
                        @foreach($globalMenuItems as $menu)
                            @if($menu->is_visible && $menu->visibleChildren->count() > 0)
                                <!-- Menu with Submenu -->
                                <div x-data="{ open: {{ $menu->isActive() || $menu->hasActiveChildren() ? 'true' : 'false' }} }">
                                    <button @click="open = !open" class="w-full flex items-center justify-between text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ $menu->isActive() || $menu->hasActiveChildren() ? 'text-blue-600 bg-blue-50' : '' }}">
                                        <span class="flex items-center">
                                            @if($menu->icon && $menu->show_icon)
                                                <i class="{{ $menu->icon }} mr-3 w-5"></i>
                                            @endif
                                            {{ $menu->title }}
                                            @if($menu->isActive() || $menu->hasActiveChildren())
                                                <span class="ml-2 px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                                            @endif
                                        </span>
                                        <i class="fas fa-chevron-down transition-transform duration-200" :class="open ? 'rotate-180' : ''"></i>
                                    </button>
                                    <div x-show="open" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 -translate-y-1" class="ml-6 mt-1 space-y-1">
                                        @foreach($menu->visibleChildren as $child)
                                            <a href="{{ $child->url }}" class="flex items-center text-gray-600 hover:text-blue-600 hover:bg-blue-50 px-4 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 {{ $child->isActive() ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                                                @if($child->icon && $child->show_icon)
                                                    <i class="{{ $child->icon }} mr-3 w-4"></i>
                                                @endif
                                                {{ $child->title }}
                                                @if($child->isActive())
                                                    <i class="fas fa-check ml-auto text-blue-600 text-xs"></i>
                                                @endif
                                            </a>
                                        @endforeach
                                    </div>
                                </div>
                            @elseif($menu->is_visible)
                                <!-- Simple Menu -->
                                <a href="{{ $menu->url }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ $menu->isActive() ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                                    @if($menu->icon && $menu->show_icon)
                                        <i class="{{ $menu->icon }} mr-3 w-5"></i>
                                    @endif
                                    {{ $menu->title }}
                                    @if($menu->isActive())
                                        <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                                    @endif
                                </a>
                            @endif
                        @endforeach
                    @else
                        <!-- Fallback Static Menu -->
                        <a href="{{ route('home') }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ request()->routeIs('home') ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                            <i class="fas fa-home mr-3 w-5"></i>
                            Beranda
                            @if(request()->routeIs('home'))
                                <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                            @endif
                        </a>
                        <a href="{{ route('about') }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ request()->routeIs('about') || request()->is('tentang-kami*') ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                            <i class="fas fa-info-circle mr-3 w-5"></i>
                            Tentang Kami
                            @if(request()->routeIs('about') || request()->is('tentang-kami*'))
                                <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                            @endif
                        </a>
                        <a href="{{ route('services.index') }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ request()->routeIs('services*') || request()->is('layanan*') ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                            <i class="fas fa-cogs mr-3 w-5"></i>
                            Layanan
                            @if(request()->routeIs('services*') || request()->is('layanan*'))
                                <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                            @endif
                        </a>
                        <a href="{{ route('products.index') }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ request()->routeIs('products*') || request()->is('produk*') ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                            <i class="fas fa-shopping-cart mr-3 w-5"></i>
                            Produk
                            @if(request()->routeIs('products*') || request()->is('produk*'))
                                <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                            @endif
                        </a>
                        <a href="{{ route('projects.index') }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ request()->routeIs('projects*') || request()->is('portofolio*') ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                            <i class="fas fa-briefcase mr-3 w-5"></i>
                            Portofolio
                            @if(request()->routeIs('projects*') || request()->is('portofolio*'))
                                <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                            @endif
                        </a>
                        <a href="{{ route('articles.index') }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ request()->routeIs('articles*') || request()->is('artikel*') ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                            <i class="fas fa-newspaper mr-3 w-5"></i>
                            Artikel
                            @if(request()->routeIs('articles*') || request()->is('artikel*'))
                                <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                            @endif
                        </a>
                        <a href="{{ route('careers.index') }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ request()->routeIs('careers*') || request()->is('karier*') ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                            <i class="fas fa-user-tie mr-3 w-5"></i>
                            Karier
                            @if(request()->routeIs('careers*') || request()->is('karier*'))
                                <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                            @endif
                        </a>
                        <a href="{{ route('contact') }}" class="flex items-center text-gray-700 hover:text-blue-600 hover:bg-blue-50 px-4 py-3 text-base font-medium rounded-lg transition-all duration-200 {{ request()->routeIs('contact') || request()->is('kontak*') ? 'text-blue-600 bg-blue-50 border-l-2 border-blue-600' : '' }}">
                            <i class="fas fa-envelope mr-3 w-5"></i>
                            Kontak
                            @if(request()->routeIs('contact') || request()->is('kontak*'))
                                <span class="ml-auto px-2 py-0.5 text-xs bg-blue-100 text-blue-600 rounded-full">Active</span>
                            @endif
                        </a>
                    @endif
                </div>
            </div>
        </nav>
    </header>
    
    <!-- Main Content -->
    <main class="pt-16">
        @yield('content')
    </main>
    
    <!-- Footer -->
    <footer class="bg-gray-900 text-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <!-- Company Info -->
                <div class="md:col-span-2">
                    <div class="flex items-center mb-4">
                        @if(setting('logo'))
                            <img src="{{ asset('storage/'.setting('logo')) }}" alt="{{ setting('site_name') }}" class="h-8 w-auto">
                        @else
                            <span class="text-2xl font-bold text-white">{{ setting('site_name', 'Company') }}</span>
                        @endif
                    </div>
                    <p class="text-gray-300 mb-4 max-w-md">
                        {{ setting('footer_description', 'Professional company providing excellent services and solutions for your business needs.') }}
                    </p>
                    <!-- Social Media -->
                    <div class="flex space-x-4">
                        @if(setting('facebook_url'))
                            <a href="{{ setting('facebook_url') }}" class="text-gray-300 hover:text-white transition-colors">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        @endif
                        @if(setting('twitter_url'))
                            <a href="{{ setting('twitter_url') }}" class="text-gray-300 hover:text-white transition-colors">
                                <i class="fab fa-twitter"></i>
                            </a>
                        @endif
                        @if(setting('linkedin_url'))
                            <a href="{{ setting('linkedin_url') }}" class="text-gray-300 hover:text-white transition-colors">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        @endif
                        @if(setting('instagram_url'))
                            <a href="{{ setting('instagram_url') }}" class="text-gray-300 hover:text-white transition-colors">
                                <i class="fab fa-instagram"></i>
                            </a>
                        @endif
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Quick Links</h3>
                    <ul class="space-y-2">
                        @if(isset($globalMenuItems))
                            @foreach($globalMenuItems->take(6) as $menu)
                                @if($menu->is_visible && !$menu->is_system) {{-- Show only visible non-system menus --}}
                                    <li>
                                        <a href="{{ $menu->url }}" class="text-gray-300 hover:text-white transition-colors">
                                            @if($menu->icon && $menu->show_icon)
                                                <i class="{{ $menu->icon }} mr-2"></i>
                                            @endif
                                            {{ $menu->title }}
                                        </a>
                                    </li>
                                @endif
                            @endforeach
                        @else
                            {{-- Fallback static links --}}
                            <li><a href="{{ route('about') }}" class="text-gray-300 hover:text-white transition-colors">Tentang Kami</a></li>
                            <li><a href="{{ route('services.index') }}" class="text-gray-300 hover:text-white transition-colors">Layanan</a></li>
                            <li><a href="{{ route('projects.index') }}" class="text-gray-300 hover:text-white transition-colors">Portofolio</a></li>
                            <li><a href="{{ route('careers.index') }}" class="text-gray-300 hover:text-white transition-colors">Karier</a></li>
                        @endif
                    </ul>
                </div>
                
                <!-- Contact Info -->
                <div>
                    <h3 class="text-lg font-semibold mb-4">Kontak</h3>
                    <ul class="space-y-2">
                        @if(setting('contact_address'))
                            <li class="text-gray-300">
                                <i class="fas fa-map-marker-alt mr-2"></i>
                                {{ setting('contact_address') }}
                            </li>
                        @endif
                        @if(setting('contact_phone'))
                            <li class="text-gray-300">
                                <i class="fas fa-phone mr-2"></i>
                                {{ setting('contact_phone') }}
                            </li>
                        @endif
                        @if(setting('contact_email'))
                            <li class="text-gray-300">
                                <i class="fas fa-envelope mr-2"></i>
                                {{ setting('contact_email') }}
                            </li>
                        @endif
                    </ul>
                </div>
            </div>
            
            <div class="border-t border-gray-800 pt-8 mt-8">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <p class="text-gray-300 text-sm">
                        © {{ date('Y') }} {{ setting('site_name', 'Company Profile') }}. All rights reserved.
                    </p>
                    <div class="flex space-x-6 mt-4 md:mt-0">
                        <a href="#" class="text-gray-300 hover:text-white text-sm transition-colors">Privacy Policy</a>
                        <a href="#" class="text-gray-300 hover:text-white text-sm transition-colors">Terms & Conditions</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    
    @stack('scripts')
    
    <script>
        // Mobile menu toggle
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuButton = document.querySelector('.mobile-menu-button');
            const mobileMenu = document.querySelector('.mobile-menu');
            
            if (mobileMenuButton && mobileMenu) {
                mobileMenuButton.addEventListener('click', function() {
                    mobileMenu.classList.toggle('hidden');
                });
            }
        });
    </script>
</body>
</html>
