@extends('layouts.frontend')

@section('title', $service->meta_title ?: $service->title . ' - ' . setting('site_name'))
@section('meta_description', $service->meta_description ?: $service->short_description)

@push('styles')
<style>
.service-content {
    color: #4B5563;
    line-height: 1.75;
}

.service-content p {
    margin-bottom: 1.5rem;
    color: #4B5563;
}

.service-content h1, 
.service-content h2, 
.service-content h3, 
.service-content h4, 
.service-content h5, 
.service-content h6 {
    color: #111827;
    font-weight: 600;
    margin-top: 2rem;
    margin-bottom: 1rem;
}

.service-content h2 {
    font-size: 1.875rem;
    line-height: 2.25rem;
}

.service-content h3 {
    font-size: 1.5rem;
    line-height: 2rem;
}

.service-content ol {
    counter-reset: list-counter;
    list-style: none;
    padding-left: 0;
    margin: 1.5rem 0;
}

.service-content ol li {
    counter-increment: list-counter;
    position: relative;
    padding-left: 3rem;
    margin-bottom: 0.75rem;
    color: #4B5563;
}

.service-content ol li::before {
    content: counter(list-counter);
    position: absolute;
    left: 0;
    top: 0;
    background: #3B82F6;
    color: white;
    width: 1.75rem;
    height: 1.75rem;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.875rem;
    font-weight: 600;
}

.service-content ul {
    list-style: none;
    padding-left: 0;
    margin: 1.5rem 0;
}

.service-content ul li {
    position: relative;
    padding-left: 2rem;
    margin-bottom: 0.5rem;
    color: #4B5563;
}

.service-content ul li::before {
    content: "•";
    position: absolute;
    left: 0;
    color: #3B82F6;
    font-weight: bold;
    font-size: 1.25rem;
}

.service-content strong {
    color: #111827;
    font-weight: 600;
}

.service-content a {
    color: #3B82F6;
    text-decoration: underline;
}

.service-content a:hover {
    color: #1D4ED8;
}

.service-content blockquote {
    border-left: 4px solid #3B82F6;
    padding-left: 1rem;
    margin: 1.5rem 0;
    font-style: italic;
    color: #6B7280;
}
</style>
@endpush

@section('content')
<!-- Service Hero Section -->
<section class="relative min-h-[80vh] flex items-center justify-center bg-gradient-to-br from-blue-900 to-blue-700">
    <div class="absolute inset-0 bg-black opacity-50"></div>
    
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Breadcrumb -->
        <nav class="text-white mb-8">
            <ol class="flex items-center space-x-2 text-sm">
                <li><a href="{{ route('home') }}" class="hover:text-blue-200">Beranda</a></li>
                <li><span class="mx-2">/</span></li>
                <li><a href="{{ route('services.index') }}" class="hover:text-blue-200">Layanan</a></li>
                <li><span class="mx-2">/</span></li>
                <li class="text-blue-200">{{ $service->title }}</li>
            </ol>
        </nav>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center text-white">
            <div>
                <h1 class="text-4xl md:text-5xl font-bold mb-6">{{ $service->title }}</h1>
                <p class="text-xl opacity-90 leading-relaxed">{{ $service->short_description }}</p>
                
                @if($service->is_featured)
                    <div class="mt-6">
                        <span class="bg-blue-500 text-white text-sm font-semibold px-4 py-2 rounded-full">
                            <i class="fas fa-star mr-1"></i>
                            Layanan Unggulan
                        </span>
                    </div>
                @endif
            </div>
            
            <div class="text-center">
                @if($service->icon)
                    <div class="text-8xl mb-6 text-blue-200">
                        <i class="{{ $service->icon }}"></i>
                    </div>
                @elseif($service->image)
                    <img src="{{ asset($service->image) }}" alt="{{ $service->title }}" class="w-full max-w-md mx-auto rounded-lg shadow-xl">
                @endif
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
            <!-- Main Content -->
            <div class="lg:col-span-2">
                <div class="prose prose-lg max-w-none">
                    @if($service->description)
                        <div class="service-content">
                            {!! $service->description !!}
                        </div>
                    @endif
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="space-y-8">
                <!-- Contact Card -->
                <div class="bg-blue-50 rounded-xl p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Butuh Konsultasi?</h3>
                    <p class="text-gray-600 mb-6">Diskusikan kebutuhan proyek Anda dengan tim ahli kami</p>
                    
                    <div class="space-y-4">
                        <a href="{{ route('contact') }}" class="block bg-blue-600 hover:bg-blue-700 text-white text-center px-6 py-3 rounded-lg font-semibold transition-colors">
                            Konsultasi Gratis
                        </a>
                        
                        @if(setting('contact_whatsapp'))
                            <a href="https://wa.me/{{ str_replace(['+', ' ', '-'], '', setting('contact_whatsapp')) }}" 
                               target="_blank"
                               class="block bg-green-600 hover:bg-green-700 text-white text-center px-6 py-3 rounded-lg font-semibold transition-colors">
                                <i class="fab fa-whatsapp mr-2"></i>
                                WhatsApp
                            </a>
                        @endif
                    </div>
                </div>
                
                <!-- Service Features -->
                <div class="bg-white border border-gray-200 rounded-xl p-6">
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Keunggulan Layanan</h3>
                    <ul class="space-y-3">
                        <li class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-3"></i>
                            <span class="text-gray-700">Konsultasi gratis</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-3"></i>
                            <span class="text-gray-700">Tim berpengalaman</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-3"></i>
                            <span class="text-gray-700">Teknologi terdepan</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-3"></i>
                            <span class="text-gray-700">Support berkelanjutan</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-3"></i>
                            <span class="text-gray-700">Harga kompetitif</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Services -->
@if($relatedServices && $relatedServices->count() > 0)
<section class="py-20 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Layanan Terkait</h2>
            <p class="text-xl text-gray-600">Layanan lain yang mungkin Anda butuhkan</p>
        </div>
          <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($relatedServices as $relatedService)
                <x-service-card :service="$relatedService" variant="compact" />
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- CTA Section -->
<section class="py-20 bg-blue-900 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-4">Siap Memulai Proyek Anda?</h2>
        <p class="text-xl mb-8 opacity-90 max-w-3xl mx-auto">
            Konsultasikan kebutuhan {{ $service->title }} Anda dengan tim expert kami dan dapatkan solusi terbaik
        </p>
        
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('contact') }}" class="bg-white text-blue-900 hover:bg-gray-100 px-8 py-4 rounded-lg text-lg font-semibold transition-colors">
                Dapatkan Penawaran
            </a>
            <a href="{{ route('projects.index') }}" class="border-2 border-white text-white hover:bg-white hover:text-blue-900 px-8 py-4 rounded-lg text-lg font-semibold transition-all">
                Lihat Portfolio
            </a>
        </div>
    </div>
</section>
@endsection
